/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

class UnearthDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    public UnearthDelayedTriggeredAbility() {
        super(new ExileTargetEffect());
    }

    protected UnearthDelayedTriggeredAbility(UnearthDelayedTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public UnearthDelayedTriggeredAbility copy() {
        return new UnearthDelayedTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.END_TURN_STEP_PRE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getPlayerId().equals(this.controllerId)) {
            return false;
        }
        MageObjectReference object = new MageObjectReference(this.getSourceId(), this.getStackMomentSourceZCC() + 1, game);
        Permanent permanent = object.getPermanent(game);
        if (permanent == null || !permanent.isPhasedIn()) {
            return true;
        }
        this.getEffects().setTargetPointer(new FixedTarget(permanent, game));
        return true;
    }

    @Override
    public String getRule() {
        return "Exile {this} at the beginning of the next end step";
    }
}

