/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.EntersBattlefieldAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceHasCounterCondition;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.effects.common.counter.RemoveCounterSourceEffect;
import mage.abilities.keyword.VanishingTriggeredAbility;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.counters.CounterType;
import mage.util.CardUtil;

public class VanishingAbility
extends EntersBattlefieldAbility {
    private static final Condition condition = new SourceHasCounterCondition(CounterType.TIME);
    private final int amount;

    public VanishingAbility(int amount) {
        super(new AddCountersSourceEffect(CounterType.TIME.createInstance(amount)));
        this.amount = amount;
        this.addSubAbility(new BeginningOfUpkeepTriggeredAbility(new RemoveCounterSourceEffect(CounterType.TIME.createInstance()).setText("remove a time counter from it"), false).withInterveningIf(condition).setRuleVisible(false));
        this.addSubAbility(new VanishingTriggeredAbility());
    }

    private VanishingAbility(VanishingAbility ability) {
        super(ability);
        this.amount = ability.amount;
    }

    @Override
    public VanishingAbility copy() {
        return new VanishingAbility(this);
    }

    @Override
    public String getRule() {
        if (this.amount > 0) {
            return "Vanishing " + this.amount + " <i>(This permanent enters the battlefield with " + CardUtil.numberToText(this.amount) + " time counters on it. At the beginning of your upkeep, remove a time counter from it. When the last is removed, sacrifice it.)</i>";
        }
        return "Vanishing <i>(At the beginning of your upkeep, remove a time counter from this permanent. When the last is removed, sacrifice it.)</i>";
    }
}

