/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.mana;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.choices.Choice;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AnyColorPermanentTypesManaEffect
extends ManaEffect {
    private final FilterPermanent filter;
    private transient boolean inManaTypeCalculation = false;

    public AnyColorPermanentTypesManaEffect(TargetController targetController, FilterPermanent permanentTypes) {
        this.filter = permanentTypes;
        this.filter.add(targetController.getControllerPredicate());
        this.staticText = "Add one mana of any color among " + permanentTypes.getMessage() + " " + (targetController == TargetController.OPPONENT ? "an opponent controls." : "you control.");
    }

    protected AnyColorPermanentTypesManaEffect(AnyColorPermanentTypesManaEffect effect) {
        super(effect);
        this.filter = effect.filter.copy();
    }

    @Override
    public List<Mana> getNetMana(Game game, Ability source) {
        return game == null ? new ArrayList<Mana>() : ManaType.getManaListFromManaTypes(this.getManaTypes(game, source), true);
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        if (game == null) {
            return null;
        }
        Set<ManaType> types = this.getManaTypes(game, source);
        if (types.isEmpty()) {
            return null;
        }
        Choice choice = ManaType.getChoiceOfManaTypes(types, true);
        if (choice.getChoices().size() == 1) {
            choice.setChoice(choice.getChoices().iterator().next());
        } else {
            Player player = game.getPlayer(source.getControllerId());
            if (player == null || !player.choose(Outcome.PutManaInPool, choice, game)) {
                return null;
            }
        }
        ManaType chosenType = ManaType.findByName(choice.getChoice());
        return chosenType == null ? null : new Mana(chosenType);
    }

    private Set<ManaType> getManaTypes(Game game, Ability source) {
        HashSet<ManaType> manaTypes = new HashSet<ManaType>(6);
        if (game == null || game.getPhase() == null || this.inManaTypeCalculation) {
            return manaTypes;
        }
        this.inManaTypeCalculation = true;
        List<Permanent> permanents = game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game);
        for (Permanent permanent : permanents) {
            ObjectColor permanentColor = permanent.getColor(game);
            if (permanentColor.isBlack()) {
                manaTypes.add(ManaType.BLACK);
            }
            if (permanentColor.isBlue()) {
                manaTypes.add(ManaType.BLUE);
            }
            if (permanentColor.isGreen()) {
                manaTypes.add(ManaType.GREEN);
            }
            if (permanentColor.isRed()) {
                manaTypes.add(ManaType.RED);
            }
            if (permanentColor.isWhite()) {
                manaTypes.add(ManaType.WHITE);
            }
            if (manaTypes.size() != 5) continue;
            break;
        }
        this.inManaTypeCalculation = false;
        return manaTypes;
    }

    @Override
    public AnyColorPermanentTypesManaEffect copy() {
        return new AnyColorPermanentTypesManaEffect(this);
    }
}

