/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.triggers;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;

public abstract class AtStepTriggeredAbility
extends TriggeredAbilityImpl {
    protected final TargetController targetController;
    private Boolean setTargetPointer;

    protected AtStepTriggeredAbility(Zone zone, TargetController targetController, Effect effect, boolean optional) {
        super(zone, effect, optional);
        this.targetController = targetController;
        this.setTriggerPhrase(this.generateTriggerPhrase());
    }

    protected AtStepTriggeredAbility(AtStepTriggeredAbility ability) {
        super(ability);
        this.targetController = ability.targetController;
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (this.checkTargetController(event, game)) {
            this.setTargetPointerIfNeeded(event.getPlayerId());
            return true;
        }
        return false;
    }

    private boolean checkTargetController(GameEvent event, Game game) {
        switch (this.targetController) {
            case YOU: {
                return this.isControlledBy(event.getPlayerId());
            }
            case NOT_YOU: {
                return !this.isControlledBy(event.getPlayerId());
            }
            case ANY: 
            case NEXT: 
            case EACH_PLAYER: {
                return true;
            }
            case OPPONENT: {
                Player player = game.getPlayer(this.getControllerId());
                return player != null && player.hasOpponent(event.getPlayerId(), game);
            }
            case ENCHANTED: {
                Permanent permanent = this.getSourcePermanentIfItStillExists(game);
                return permanent != null && game.isActivePlayer(permanent.getAttachedTo());
            }
            case CONTROLLER_ATTACHED_TO: {
                Permanent attachment = this.getSourcePermanentIfItStillExists(game);
                if (attachment == null) {
                    return false;
                }
                Permanent attachedTo = game.getPermanent(attachment.getAttachedTo());
                return attachedTo != null && game.isActivePlayer(attachedTo.getControllerId());
            }
            case MONARCH: {
                return event.getPlayerId().equals(game.getMonarchId());
            }
        }
        throw new UnsupportedOperationException("Unsupported TargetController in AtStepTriggeredAbility: " + (Object)((Object)this.targetController));
    }

    public AtStepTriggeredAbility withTargetPointerSet(boolean setTargetPointer) {
        this.setTargetPointer = setTargetPointer;
        return this;
    }

    private void setTargetPointerIfNeeded(UUID playerId) {
        if (Boolean.TRUE.equals(this.setTargetPointer) || this.setTargetPointer == null && this.getTargets().isEmpty()) {
            this.getEffects().setTargetPointer(new FixedTarget(playerId));
        }
    }

    protected abstract String generateTriggerPhrase();
}

