/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.util.UUID;
import mage.abilities.SpellAbility;
import mage.cards.AdventureSpellCard;
import mage.cards.CardSetInfo;
import mage.cards.CardWithSpellOption;
import mage.constants.CardType;
import mage.constants.SpellAbilityType;
import mage.constants.Zone;
import mage.game.Game;

public abstract class AdventureCard
extends CardWithSpellOption {
    public AdventureCard(UUID ownerId, CardSetInfo setInfo, CardType[] types, CardType[] typesSpell, String costs, String adventureName, String costsSpell) {
        super(ownerId, setInfo, types, costs);
        this.spellCard = new AdventureSpellCard(ownerId, setInfo, adventureName, typesSpell, costsSpell, this);
    }

    public AdventureCard(AdventureCard card) {
        super(card);
    }

    public void finalizeAdventure() {
        this.spellCard.finalizeSpell();
    }

    @Override
    public boolean cast(Game game, Zone fromZone, SpellAbility ability, UUID controllerId) {
        if (ability.getSpellAbilityType() == SpellAbilityType.ADVENTURE_SPELL) {
            return this.getSpellCard().cast(game, fromZone, ability, controllerId);
        }
        this.getSpellCard().getSpellAbility().setControllerId(controllerId);
        return super.cast(game, fromZone, ability, controllerId);
    }
}

