/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.Mana;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.cards.MeldCard;
import mage.constants.CardType;
import mage.constants.Rarity;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.Counters;
import mage.filter.FilterMana;
import mage.game.Game;
import mage.game.GameState;
import mage.game.Ownerable;
import mage.game.permanent.Permanent;
import mage.util.ManaUtil;
import mage.watchers.common.CommanderPlaysCountWatcher;

public interface Card
extends MageObject,
Ownerable {
    public Rarity getRarity();

    public void setRarity(Rarity var1);

    public void setOwnerId(UUID var1);

    public Abilities<Ability> getAbilities(Game var1);

    public void setSpellAbility(SpellAbility var1);

    public SpellAbility getSpellAbility();

    public List<String> getRules();

    public List<String> getRules(Game var1);

    public void applyEnterWithCounters(Permanent var1, Ability var2, Game var3);

    public void setFaceDown(boolean var1, Game var2);

    public boolean isFaceDown(Game var1);

    public boolean turnFaceUp(Ability var1, Game var2, UUID var3);

    public boolean turnFaceDown(Ability var1, Game var2, UUID var3);

    public boolean isFlipCard();

    public String getFlipCardName();

    public boolean isTransformable();

    public Card getSecondCardFace();

    public SpellAbility getSecondFaceSpellAbility();

    public boolean isNightCard();

    default public boolean meldsWith(Card card) {
        return false;
    }

    default public Class<? extends Card> getMeldsToClazz() {
        return null;
    }

    default public MeldCard getMeldsToCard() {
        return null;
    }

    default public boolean isExtraDeckCard() {
        return false;
    }

    public void assignNewId();

    public void addInfo(String var1, String var2, Game var3);

    public boolean moveToZone(Zone var1, Ability var2, Game var3, boolean var4);

    public boolean moveToZone(Zone var1, Ability var2, Game var3, boolean var4, List<UUID> var5);

    public boolean moveToExile(UUID var1, String var2, Ability var3, Game var4);

    public boolean moveToExile(UUID var1, String var2, Ability var3, Game var4, List<UUID> var5);

    public boolean cast(Game var1, Zone var2, SpellAbility var3, UUID var4);

    public boolean removeFromZone(Game var1, Zone var2, Ability var3);

    public boolean putOntoBattlefield(Game var1, Zone var2, Ability var3, UUID var4);

    public boolean putOntoBattlefield(Game var1, Zone var2, Ability var3, UUID var4, boolean var5);

    public boolean putOntoBattlefield(Game var1, Zone var2, Ability var3, UUID var4, boolean var5, boolean var6);

    public boolean putOntoBattlefield(Game var1, Zone var2, Ability var3, UUID var4, boolean var5, boolean var6, List<UUID> var7);

    public void setZone(Zone var1, Game var2);

    public List<Mana> getMana();

    public Counters getCounters(Game var1);

    public Counters getCounters(GameState var1);

    public void addAbility(Ability var1);

    public void looseAllAbilities(Game var1);

    public boolean addCounters(Counter var1, Ability var2, Game var3);

    public boolean addCounters(Counter var1, UUID var2, Ability var3, Game var4);

    public boolean addCounters(Counter var1, UUID var2, Ability var3, Game var4, boolean var5);

    public boolean addCounters(Counter var1, UUID var2, Ability var3, Game var4, List<UUID> var5);

    public boolean addCounters(Counter var1, UUID var2, Ability var3, Game var4, List<UUID> var5, boolean var6);

    public boolean addCounters(Counter var1, UUID var2, Ability var3, Game var4, List<UUID> var5, boolean var6, int var7);

    default public void removeCounters(String counterName, int amount, Ability source, Game game) {
        this.removeCounters(counterName, amount, source, game, false);
    }

    public int removeCounters(String var1, int var2, Ability var3, Game var4, boolean var5);

    default public int removeCounters(Counter counter, Ability source, Game game) {
        return this.removeCounters(counter, source, game, false);
    }

    public int removeCounters(Counter var1, Ability var2, Game var3, boolean var4);

    default public int removeAllCounters(Ability source, Game game) {
        return this.removeAllCounters(source, game, false);
    }

    public int removeAllCounters(Ability var1, Game var2, boolean var3);

    default public int removeAllCounters(String counterName, Ability source, Game game) {
        return this.removeAllCounters(counterName, source, game, false);
    }

    public int removeAllCounters(String var1, Ability var2, Game var3, boolean var4);

    @Override
    public Card copy();

    public Card getMainCard();

    public FilterMana getColorIdentity();

    public List<UUID> getAttachments();

    public boolean cantBeAttachedBy(MageObject var1, Ability var2, Game var3, boolean var4);

    public boolean addAttachment(UUID var1, Ability var2, Game var3);

    public boolean removeAttachment(UUID var1, Ability var2, Game var3);

    default public boolean isOwnedBy(UUID controllerId) {
        return this.getOwnerId().equals(controllerId);
    }

    default public boolean commanderCost(Game game, Ability source, Ability abilityToModify) {
        CommanderPlaysCountWatcher watcher = game.getState().getWatcher(CommanderPlaysCountWatcher.class);
        int castCount = watcher.getPlaysCount(this.getMainCard().getId());
        if (castCount > 0) {
            abilityToModify.addManaCostsToPay(ManaUtil.createManaCost(2 * castCount, false));
        }
        return true;
    }

    public List<CardType> getCardTypeForDeckbuilding();

    public boolean hasCardTypeForDeckbuilding(CardType var1);

    public boolean hasSubTypeForDeckbuilding(SubType var1);
}

