/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.util.Arrays;
import java.util.stream.Collectors;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.ShuffleIntoLibrarySourceEffect;
import mage.constants.CardType;
import mage.util.CardUtil;

class OmenCardSpellAbility
extends SpellAbility {
    private String nameFull;
    private boolean finalized = false;

    public OmenCardSpellAbility(SpellAbility baseSpellAbility, String omenName, CardType[] cardTypes, String costs) {
        super(baseSpellAbility);
        this.setName(cardTypes, omenName, costs);
        this.setCardName(omenName);
    }

    public void finalizeOmen() {
        if (this.finalized) {
            throw new IllegalStateException("Wrong code usage. Omen (" + this.cardName + ") need to call finalizeOmen() exactly once.");
        }
        ShuffleIntoLibrarySourceEffect effect = new ShuffleIntoLibrarySourceEffect();
        effect.setText("");
        this.addEffect(effect);
        this.finalized = true;
    }

    protected OmenCardSpellAbility(OmenCardSpellAbility ability) {
        super(ability);
        this.nameFull = ability.nameFull;
        if (!ability.finalized) {
            throw new IllegalStateException("Wrong code usage. Omen (" + this.cardName + ") need to call finalizeOmen() at the very end of the card's constructor.");
        }
        this.finalized = true;
    }

    public void setName(CardType[] cardTypes, String omenName, String costs) {
        this.nameFull = "Omen " + Arrays.stream(cardTypes).map(CardType::toString).collect(Collectors.joining(" ")) + " &mdash; " + omenName;
        this.name = this.nameFull + " " + costs;
    }

    @Override
    public String getRule(boolean all) {
        return this.nameFull + " " + this.getManaCosts().getText() + " &mdash; " + CardUtil.getTextWithFirstCharUpperCase(super.getRule(false)) + " <i>(Then shuffle this card into its owner's library.)</i>";
    }

    @Override
    public OmenCardSpellAbility copy() {
        return new OmenCardSpellAbility(this);
    }
}

