/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mage.Mana;
import mage.cards.Card;
import mage.cards.ExpansionSet;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.constants.CardType;
import mage.constants.ColoredManaSymbol;
import mage.constants.Rarity;
import mage.filter.FilterMana;
import mage.util.ClassScanner;
import mage.util.RandomUtil;
import org.apache.log4j.Logger;

public class Sets
extends HashMap<String, ExpansionSet> {
    private static final Logger logger = Logger.getLogger(Sets.class);
    private static final Sets instance = new Sets();
    private final Set<String> customSets = new HashSet<String>();

    public static Sets getInstance() {
        return instance;
    }

    private Sets() {
        ArrayList<String> packages = new ArrayList<String>();
        packages.add("mage.sets");
        for (Class c : ClassScanner.findClasses(null, packages, ExpansionSet.class)) {
            try {
                this.addSet((ExpansionSet)c.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]));
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    public void addSet(ExpansionSet set) {
        if (this.containsKey(set.getCode())) {
            throw new IllegalArgumentException("Set code " + set.getCode() + " already exists.");
        }
        this.put(set.getCode(), set);
        if (set.getSetType().isCustomSet()) {
            this.customSets.add(set.getCode());
        }
    }

    public static List<Card> generateRandomCardPool(int cardsCount, List<ColoredManaSymbol> allowedColors) {
        return Sets.generateRandomCardPool(cardsCount, allowedColors, false);
    }

    public static List<Card> generateRandomCardPool(int cardsCount, List<ColoredManaSymbol> allowedColors, boolean onlyBasicLands) {
        return Sets.generateRandomCardPool(cardsCount, allowedColors, onlyBasicLands, null);
    }

    public static List<Card> generateRandomCardPool(int cardsCount, List<ColoredManaSymbol> allowedColors, boolean onlyBasicLands, List<String> allowedSets) {
        CardCriteria criteria = new CardCriteria();
        if (onlyBasicLands) {
            criteria.rarities(Rarity.LAND);
            criteria.colorless(true);
        } else {
            criteria.notTypes(CardType.LAND);
            criteria.white(false);
            criteria.blue(false);
            criteria.black(false);
            criteria.red(false);
            criteria.green(false);
            criteria.colorless(false);
        }
        if (allowedSets != null && allowedSets.size() > 0) {
            for (String string : allowedSets) {
                criteria.setCodes(string);
            }
        }
        FilterMana manaNeed = new FilterMana();
        for (ColoredManaSymbol color : allowedColors) {
            switch (color) {
                case W: {
                    manaNeed.setWhite(true);
                    criteria.white(true);
                    break;
                }
                case U: {
                    manaNeed.setBlue(true);
                    criteria.blue(true);
                    break;
                }
                case B: {
                    manaNeed.setBlack(true);
                    criteria.black(true);
                    break;
                }
                case R: {
                    manaNeed.setRed(true);
                    criteria.red(true);
                    break;
                }
                case G: {
                    manaNeed.setGreen(true);
                    criteria.green(true);
                }
            }
        }
        List<CardInfo> list = CardRepository.instance.findCards(criteria);
        if (list.isEmpty()) {
            throw new IllegalStateException("Can't find cards for chosen colors to generate deck: " + allowedColors);
        }
        int count = 0;
        int tries = 0;
        ArrayList<Card> cardPool = new ArrayList<Card>();
        while (count < cardsCount) {
            Card card;
            CardInfo cardInfo = list.get(RandomUtil.nextInt(list.size()));
            Card card2 = card = cardInfo != null ? cardInfo.createCard() : null;
            if (card != null) {
                FilterMana manaCard = card.getColorIdentity();
                boolean cardManaOK = true;
                if (onlyBasicLands) {
                    for (Mana manaLand : card.getMana()) {
                        if (manaLand.getWhite() > 0 && !manaNeed.isWhite()) {
                            cardManaOK = false;
                        }
                        if (manaLand.getBlue() > 0 && !manaNeed.isBlue()) {
                            cardManaOK = false;
                        }
                        if (manaLand.getBlack() > 0 && !manaNeed.isBlack()) {
                            cardManaOK = false;
                        }
                        if (manaLand.getRed() > 0 && !manaNeed.isRed()) {
                            cardManaOK = false;
                        }
                        if (manaLand.getGreen() > 0 && !manaNeed.isGreen()) {
                            cardManaOK = false;
                        }
                        if (manaLand.getColorless() <= 0) continue;
                        cardManaOK = false;
                    }
                } else {
                    if (manaCard.isWhite() && !manaNeed.isWhite()) {
                        cardManaOK = false;
                    }
                    if (manaCard.isBlue() && !manaNeed.isBlue()) {
                        cardManaOK = false;
                    }
                    if (manaCard.isBlack() && !manaNeed.isBlack()) {
                        cardManaOK = false;
                    }
                    if (manaCard.isRed() && !manaNeed.isRed()) {
                        cardManaOK = false;
                    }
                    if (manaCard.isGreen() && !manaNeed.isGreen()) {
                        cardManaOK = false;
                    }
                }
                if (cardManaOK) {
                    cardPool.add(card);
                    ++count;
                }
            }
            if (++tries <= 4096) continue;
            throw new IllegalStateException("Not enough cards for chosen colors to generate deck: " + allowedColors);
        }
        return cardPool;
    }

    public static ExpansionSet findSet(String code) {
        if (instance.containsKey(code)) {
            return (ExpansionSet)instance.get(code);
        }
        return null;
    }

    public static ExpansionSet findSetByName(String setName) {
        return instance.values().stream().filter(expansionSet -> expansionSet.getName().equals(setName)).findFirst().orElse(null);
    }

    public static ExpansionSet.SetCardInfo findCardByClass(Class<?> clazz, String preferredSetCode, String preferredCardNumber) {
        ExpansionSet.SetCardInfo info;
        block2: {
            Map.Entry entry;
            info = null;
            if (instance.containsKey(preferredSetCode)) {
                info = ((ExpansionSet)instance.get(preferredSetCode)).findCardInfoByClass(clazz).stream().filter(card -> preferredCardNumber.isEmpty() || card.getCardNumber().equals(preferredCardNumber)).findFirst().orElse(null);
            }
            if (info != null) break block2;
            Iterator iterator = instance.entrySet().iterator();
            while (iterator.hasNext() && (info = (ExpansionSet.SetCardInfo)((ExpansionSet)(entry = iterator.next()).getValue()).findCardInfoByClass(clazz).stream().filter(card -> preferredCardNumber.isEmpty() || card.getCardNumber().equals(preferredCardNumber)).findFirst().orElse(null)) == null) {
            }
        }
        return info;
    }
}

