/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks;

import java.io.Serializable;
import mage.util.Copyable;

public class DeckCardInfo
implements Serializable,
Copyable<DeckCardInfo> {
    static final int MAX_AMOUNT_PER_CARD = 99;
    private String cardName;
    private String setCode;
    private String cardNumber;
    private int amount;

    public DeckCardInfo() {
    }

    protected DeckCardInfo(DeckCardInfo info) {
        this.cardName = info.cardName;
        this.setCode = info.setCode;
        this.cardNumber = info.cardNumber;
        this.amount = info.amount;
    }

    public DeckCardInfo(String cardName, String cardNumber, String setCode) {
        this(cardName, cardNumber, setCode, 1);
    }

    public static void makeSureCardAmountFine(int amount, String cardName) {
        if (amount > 99) {
            throw new IllegalArgumentException("Found too big amount for a deck's card: " + cardName + " - " + amount);
        }
    }

    public DeckCardInfo(String cardName, String cardNumber, String setCode, int amount) {
        DeckCardInfo.makeSureCardAmountFine(amount, cardName);
        this.cardName = cardName;
        this.cardNumber = cardNumber;
        this.setCode = setCode;
        this.amount = amount;
    }

    public String getCardName() {
        return this.cardName;
    }

    public String getSetCode() {
        return this.setCode;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public int getAmount() {
        return this.amount;
    }

    public String getCardKey() {
        return this.setCode + this.cardNumber;
    }

    @Override
    public DeckCardInfo copy() {
        return new DeckCardInfo(this);
    }
}

