/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks.exporter;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import mage.cards.decks.DeckCardInfo;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.DeckFileFilter;
import mage.cards.decks.exporter.DeckExporter;

public class MtgOnlineDeckExporter
extends DeckExporter {
    private final String ext = "dek";
    private final String description = "MTG Online's deck format (*.dek)";
    private final FileFilter fileFilter = new DeckFileFilter("dek", "MTG Online's deck format (*.dek)");

    @Override
    public void writeDeck(PrintWriter out, DeckCardLists deck) {
        HashMap<String, Integer> amount = new HashMap<String, Integer>();
        List<String> deckMain = this.prepareCardsList(deck.getCards(), amount, "M@");
        List<String> deckSideboard = this.prepareCardsList(deck.getSideboard(), amount, "S@");
        this.printCards(out, deckMain, amount, "M@");
        if (deckSideboard.size() > 0) {
            out.println();
            this.printCards(out, deckSideboard, amount, "S@");
        }
    }

    private List<String> prepareCardsList(List<DeckCardInfo> sourceCards, Map<String, Integer> amount, String prefix) {
        ArrayList<String> res = new ArrayList<String>();
        for (DeckCardInfo card : sourceCards) {
            String code = prefix + card.getCardName();
            int curAmount = amount.getOrDefault(code, 0);
            if (curAmount == 0) {
                res.add(card.getCardName());
            }
            amount.put(code, curAmount + card.getAmount());
        }
        return res;
    }

    private void printCards(PrintWriter out, List<String> deck, Map<String, Integer> amount, String prefix) {
        if (deck.size() == 0) {
            return;
        }
        boolean firstCard = true;
        for (String name : deck) {
            if (!firstCard) {
                out.println();
            }
            out.print(amount.get(prefix + name));
            out.print(' ');
            out.print(name);
            firstCard = false;
        }
        out.println();
    }

    @Override
    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    @Override
    public String getDescription() {
        return "MTG Online's deck format (*.dek)";
    }

    @Override
    public String getDefaultFileExt() {
        return "dek";
    }
}

