/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks.importer;

import mage.cards.decks.DeckCardInfo;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.importer.DeckImporter;
import mage.cards.decks.importer.PlainTextDeckImporter;
import mage.cards.repository.CardInfo;

public class DecDeckImporter
extends PlainTextDeckImporter {
    @Override
    protected void readLine(String line, DeckCardLists deckList, DeckImporter.FixedInfo fixedInfo) {
        if (line.isEmpty() || line.startsWith("//")) {
            return;
        }
        boolean sideboard = false;
        if (line.startsWith("SB:")) {
            line = line.substring(3).trim();
            sideboard = true;
        }
        int delim = line.indexOf(32);
        String lineNum = line.substring(0, delim).trim();
        String lineName = line.substring(delim).trim();
        try {
            int num = Integer.parseInt(lineNum);
            CardInfo cardInfo = this.getCardLookup().lookupCardInfo(lineName);
            if (cardInfo == null) {
                this.sbMessage.append("Could not find card: '").append(lineName).append("' at line ").append(this.lineCount).append('\n');
            } else {
                DeckCardInfo.makeSureCardAmountFine(num, cardInfo.getName());
                DeckCardInfo deckCardInfo = new DeckCardInfo(cardInfo.getName(), cardInfo.getCardNumber(), cardInfo.getSetCode());
                for (int i = 0; i < num; ++i) {
                    if (sideboard) {
                        deckList.getSideboard().add(deckCardInfo.copy());
                        continue;
                    }
                    deckList.getCards().add(deckCardInfo.copy());
                }
            }
        }
        catch (NumberFormatException nfe) {
            this.sbMessage.append("Invalid number: ").append(lineNum).append(" at line ").append(this.lineCount).append('\n');
        }
    }
}

