/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks.importer;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.importer.DeckImporter;

public abstract class JsonDeckImporter
extends DeckImporter {
    protected StringBuilder sbMessage = new StringBuilder();

    @Override
    public DeckCardLists importDeck(String fileName, StringBuilder errorMessages, boolean saveAutoFixedFile) {
        DeckCardLists deckList;
        block20: {
            File f = new File(fileName);
            deckList = new DeckCardLists();
            if (!f.exists()) {
                logger.warn((Object)("Deckfile " + fileName + " not found."));
                return deckList;
            }
            this.sbMessage.setLength(0);
            try {
                try (FileReader reader = new FileReader(f);){
                    try {
                        JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        this.readJson(json, deckList);
                        if (this.sbMessage.length() <= 0) break block20;
                        if (errorMessages != null) {
                            errorMessages.append((CharSequence)this.sbMessage);
                            break block20;
                        }
                        logger.fatal((Object)this.sbMessage);
                    }
                    catch (JsonParseException ex) {
                        logger.fatal((Object)("Can't parse json-deck: " + fileName), (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    logger.fatal(null, (Throwable)ex);
                }
            }
            catch (Exception ex) {
                logger.fatal(null, (Throwable)ex);
            }
        }
        return deckList;
    }

    @Override
    public DeckCardLists importDeck(String fileName, boolean saveAutoFixedFile) {
        return this.importDeck(fileName, null, saveAutoFixedFile);
    }

    protected abstract void readJson(JsonObject var1, DeckCardLists var2);
}

