/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks.importer;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mage.cards.decks.CardNameUtil;
import mage.cards.decks.DeckCardInfo;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.importer.CardLookup;
import mage.cards.decks.importer.DeckImporter;
import mage.cards.decks.importer.PlainTextDeckImporter;
import mage.cards.repository.CardInfo;

public class MtgaImporter
extends PlainTextDeckImporter {
    private static final Map<String, String> SET_REMAPPING = ImmutableMap.of((Object)"DAR", (Object)"DOM");
    public static final Pattern MTGA_PATTERN = Pattern.compile("(\\p{Digit}+)\\p{javaWhitespace}+(" + CardNameUtil.CARD_NAME_PATTERN.pattern() + ")(?:\\p{javaWhitespace}+\\()?(\\p{Alnum}+)?(?:\\)\\p{javaWhitespace}+)?(\\p{Graph}+)?");
    private final CardLookup lookup = this.getCardLookup();
    private boolean sideboard = false;

    @Override
    protected void readLine(String line, DeckCardLists deckList, DeckImporter.FixedInfo fixedInfo) {
        CardInfo found;
        line = line.replace(" *F*", "");
        String lowerLine = (line = line.trim()).toLowerCase(Locale.ENGLISH);
        if (lowerLine.startsWith("deck") || lowerLine.startsWith("mainboard")) {
            this.sideboard = false;
            return;
        }
        if (lowerLine.startsWith("sideboard") || lowerLine.startsWith("commander") || lowerLine.startsWith("maybeboard") || lowerLine.equals("")) {
            this.sideboard = true;
            return;
        }
        Matcher pattern = MTGA_PATTERN.matcher(CardNameUtil.normalizeCardName(line));
        if (!pattern.matches()) {
            this.sbMessage.append("Error reading '").append(line).append("'\n");
            return;
        }
        int count = Integer.parseInt(pattern.group(1));
        String name = pattern.group(2);
        if (pattern.group(3) != null) {
            String set = SET_REMAPPING.getOrDefault(pattern.group(3), pattern.group(3));
            String cardNumber = pattern.groupCount() >= 4 ? pattern.group(4) : null;
            found = this.lookup.lookupCardInfo(name, set, cardNumber);
        } else {
            found = this.lookup.lookupCardInfo(name, null, null);
        }
        if (found == null) {
            this.sbMessage.append("Could not find card for '").append(line).append("'\n");
            return;
        }
        DeckCardInfo.makeSureCardAmountFine(count, found.getName());
        List<DeckCardInfo> zone = this.sideboard ? deckList.getSideboard() : deckList.getCards();
        DeckCardInfo deckCardInfo = new DeckCardInfo(found.getName(), found.getCardNumber(), found.getSetCode());
        zone.addAll(Collections.nCopies(count, deckCardInfo.copy()));
    }

    public static boolean isMTGA(String data) {
        String firstLine = data.split("\\R", 2)[0];
        String firstLineLower = firstLine.toLowerCase(Locale.ENGLISH);
        if (firstLineLower.startsWith("deck") || firstLineLower.startsWith("mainboard") || firstLineLower.startsWith("sideboard") || firstLineLower.startsWith("commander") || firstLineLower.startsWith("maybeboard")) {
            return true;
        }
        Matcher pattern = MTGA_PATTERN.matcher(CardNameUtil.normalizeCardName(firstLine));
        return pattern.matches() && pattern.groupCount() >= 3 && pattern.group(3) != null;
    }
}

