/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks.importer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import mage.cards.decks.CardNameUtil;
import mage.cards.decks.DeckCardInfo;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.importer.DeckImporter;
import mage.cards.decks.importer.PlainTextDeckImporter;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;

public class TxtDeckImporter
extends PlainTextDeckImporter {
    private static final String[] SET_VALUES = new String[]{"lands", "creatures", "planeswalkers", "other spells", "sideboard cards", "Instant", "Land", "Enchantment", "Artifact", "Sorcery", "Planeswalker", "Creature"};
    private static final Set<String> IGNORE_NAMES = new HashSet<String>(Arrays.asList(SET_VALUES));
    private boolean sideboard = false;
    private boolean switchSideboardByEmptyLine = true;
    private boolean wasCardLines = false;

    public TxtDeckImporter(boolean haveSideboardSection) {
        if (haveSideboardSection) {
            this.switchSideboardByEmptyLine = false;
        }
    }

    @Override
    protected void readLine(String line, DeckCardLists deckList, DeckImporter.FixedInfo fixedInfo) {
        String lineName;
        String commentString = (line = line.trim()).toLowerCase(Locale.ENGLISH);
        if (commentString.startsWith("//")) {
            if (commentString.startsWith("//sideboard")) {
                this.sideboard = true;
            }
            return;
        }
        int commentDelim = line.indexOf(35);
        if (commentDelim >= 0) {
            line = line.substring(0, commentDelim).trim();
        }
        if (line.isEmpty() && !this.wasCardLines) {
            return;
        }
        if (this.switchSideboardByEmptyLine && line.isEmpty()) {
            if (!this.sideboard) {
                this.sideboard = true;
            } else {
                this.sbMessage.append("Found empty line at ").append(this.lineCount).append(", but sideboard already used. Use //sideboard switcher OR use only one empty line to devide your cards.").append('\n');
            }
            return;
        }
        boolean singleLineSideBoard = false;
        if (line.startsWith("SB:")) {
            line = line.replace("SB:", "").trim();
            singleLineSideBoard = true;
        }
        line = line.replace("\t", " ");
        int delim = line.indexOf(32);
        String lineNum = "";
        if (delim > 0 && IGNORE_NAMES.contains(lineNum = line.substring(0, delim).trim())) {
            return;
        }
        int cardAmount = 0;
        boolean haveCardAmout = false;
        if (!lineNum.isEmpty()) {
            try {
                cardAmount = Integer.parseInt(lineNum.replaceAll("\\D+", ""));
                if (cardAmount <= 0 || cardAmount >= 100) {
                    this.sbMessage.append("Invalid number (too small or too big): ").append(lineNum).append(" at line ").append(this.lineCount).append('\n');
                    return;
                }
                haveCardAmout = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (haveCardAmout) {
            lineName = line.substring(delim).trim();
        } else {
            lineName = line.trim();
            cardAmount = 1;
        }
        lineName = CardNameUtil.normalizeCardName(lineName);
        if (lineName.contains("//") && !lineName.contains(" // ")) {
            lineName = lineName.replace("//", " // ");
        }
        if (IGNORE_NAMES.contains(lineName = lineName.replaceFirst("(?<=[^/])\\s*/\\s*(?=[^/])", " // "))) {
            return;
        }
        this.wasCardLines = true;
        CardInfo cardInfo = CardRepository.instance.findPreferredCoreExpansionCard(lineName);
        if (cardInfo == null) {
            this.sbMessage.append("Could not find card: '").append(lineName).append("' at line ").append(this.lineCount).append('\n');
        } else {
            for (int i = 0; i < cardAmount; ++i) {
                if (!this.sideboard && !singleLineSideBoard) {
                    deckList.getCards().add(new DeckCardInfo(cardInfo.getName(), cardInfo.getCardNumber(), cardInfo.getSetCode()));
                    continue;
                }
                deckList.getSideboard().add(new DeckCardInfo(cardInfo.getName(), cardInfo.getCardNumber(), cardInfo.getSetCode()));
            }
        }
    }
}

