/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.ExpansionSet;
import mage.cards.Sets;
import mage.cards.SplitCard;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.cards.repository.ExpansionInfo;
import mage.cards.repository.ExpansionRepository;
import org.apache.log4j.Logger;

public final class CardScanner {
    public static boolean scanned = false;
    private static final Logger logger = Logger.getLogger(CardScanner.class);

    public static void scan() {
        CardScanner.scan(null);
    }

    public static void scan(List<String> errorsList) {
        if (scanned) {
            return;
        }
        scanned = true;
        ArrayList<CardInfo> cardsToAdd = new ArrayList<CardInfo>();
        ArrayList<ExpansionInfo> setsToAdd = new ArrayList<ExpansionInfo>();
        ArrayList<ExpansionInfo> setsToUpdate = new ArrayList<ExpansionInfo>();
        for (ExpansionSet set : Sets.getInstance().values()) {
            ExpansionInfo expansionInfo = ExpansionRepository.instance.getSetByCode(set.getCode());
            if (expansionInfo == null) {
                setsToAdd.add(new ExpansionInfo(set));
                continue;
            }
            if (expansionInfo.name.equals(set.getName()) && expansionInfo.code.equals(set.getCode()) && Objects.equals(expansionInfo.blockName, set.getBlockName()) && expansionInfo.releaseDate.equals(set.getReleaseDate()) && expansionInfo.type == set.getSetType() && expansionInfo.boosters == set.hasBoosters() && expansionInfo.basicLands == set.hasBasicLands()) continue;
            setsToUpdate.add(new ExpansionInfo(set));
        }
        ExpansionRepository.instance.saveSets(setsToAdd, setsToUpdate, ExpansionRepository.instance.getContentVersionConstant());
        for (ExpansionSet set : Sets.getInstance().values()) {
            for (ExpansionSet.SetCardInfo setInfo : set.getSetCardInfo()) {
                Card card;
                if (CardRepository.instance.findCard(set.getCode(), setInfo.getCardNumber(), false) != null || (card = CardImpl.createCard(setInfo.getCardClass(), new CardSetInfo(setInfo.getName(), set.getCode(), setInfo.getCardNumber(), setInfo.getRarity(), setInfo.getGraphicInfo()), errorsList)) == null) continue;
                cardsToAdd.add(new CardInfo(card));
                if (!(card instanceof SplitCard)) continue;
                SplitCard splitCard = (SplitCard)card;
                cardsToAdd.add(new CardInfo(splitCard.getLeftHalfCard()));
                cardsToAdd.add(new CardInfo(splitCard.getRightHalfCard()));
            }
        }
        CardRepository.instance.saveCards(cardsToAdd, CardRepository.instance.getContentVersionConstant());
    }

    public static List<Card> getAllCards() {
        return CardScanner.getAllCards(true);
    }

    public static List<Card> getAllCards(boolean ignoreCustomSets) {
        Collection sets = Sets.getInstance().values();
        ArrayList<Card> cards = new ArrayList<Card>();
        for (ExpansionSet set : sets) {
            if (ignoreCustomSets && set.getSetType().isCustomSet()) continue;
            for (ExpansionSet.SetCardInfo setInfo : set.getSetCardInfo()) {
                cards.add(CardImpl.createCard(setInfo.getCardClass(), new CardSetInfo(setInfo.getName(), set.getCode(), setInfo.getCardNumber(), setInfo.getRarity(), setInfo.getGraphicInfo())));
            }
        }
        return cards;
    }
}

