/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.repository;

import mage.util.DebugUtil;

public class DatabaseUtils {
    public static final String DB_NAME_FEEDBACK = "feedback.h2";
    public static final String DB_NAME_USERS = "authorized_user.h2";
    public static final String DB_NAME_CARDS = "cards.h2";
    public static final String DB_NAME_RECORDS = "table_record.db";
    public static final String DB_NAME_STATS = "user_stats.db";

    public static String prepareH2Connection(String dbName, boolean improveCaches) {
        String res = String.format("jdbc:h2:file:./db/%s", dbName);
        res = res + ";AUTO_SERVER=TRUE";
        res = res + ";IGNORECASE=TRUE";
        if (improveCaches) {
            res = res + ";CACHE_SIZE=" + Math.round(Math.max(150000.0, (double)Runtime.getRuntime().maxMemory() * 0.1 / 1024.0));
            res = res + ";QUERY_CACHE_SIZE=32";
        }
        if (DebugUtil.DATABASE_PROFILE_SQL_QUERIES_TO_FILE) {
            res = res + ";TRACE_LEVEL_FILE=2";
            res = res + ";QUERY_STATISTICS=TRUE";
        }
        return res;
    }

    public static String prepareSqliteConnection(String dbName) {
        return String.format("jdbc:sqlite:./db/%s", dbName);
    }
}

