/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.repository;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.util.Date;
import mage.cards.ExpansionSet;
import mage.constants.SetType;

@DatabaseTable(tableName="expansion")
public class ExpansionInfo {
    @DatabaseField(unique=true)
    protected String name;
    @DatabaseField(id=true, unique=true)
    protected String code;
    @DatabaseField
    protected String blockName;
    @DatabaseField(dataType=DataType.DATE_STRING, format="yyyy-MM-dd HH:mm:ss")
    protected Date releaseDate;
    @DatabaseField(dataType=DataType.ENUM_STRING)
    protected SetType type;
    @DatabaseField
    protected boolean boosters;
    @DatabaseField
    protected boolean basicLands;

    public ExpansionInfo() {
    }

    public ExpansionInfo(ExpansionSet expansionSet) {
        this.name = expansionSet.getName();
        this.code = expansionSet.getCode();
        this.blockName = expansionSet.getBlockName();
        this.releaseDate = expansionSet.getReleaseDate();
        this.type = expansionSet.getSetType();
        this.boosters = expansionSet.hasBoosters();
        this.basicLands = expansionSet.hasBasicLands();
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public SetType getType() {
        return this.type;
    }

    public boolean hasBoosters() {
        return this.boosters;
    }

    public boolean hasBasicLands() {
        return this.basicLands;
    }

    public String toString() {
        return this.name;
    }
}

