/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.repository;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import mage.cards.repository.DatabaseUtils;
import mage.cards.repository.ExpansionInfo;
import mage.cards.repository.RepositoryEvent;
import mage.cards.repository.RepositoryEventSource;
import mage.cards.repository.RepositoryUtil;
import mage.game.events.Listener;
import org.apache.log4j.Logger;

public enum ExpansionRepository {
    instance;

    private static final Logger logger;
    private static final String VERSION_ENTITY_NAME = "expansion";
    private static final long EXPANSION_DB_VERSION = 5L;
    private static final long EXPANSION_CONTENT_VERSION = 18L;
    private Dao<ExpansionInfo, Object> expansionDao;
    private final RepositoryEventSource eventSource = new RepositoryEventSource();
    public boolean instanceInitialized = false;

    private ExpansionRepository() {
        File file = new File("db");
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            JdbcConnectionSource connectionSource = new JdbcConnectionSource(DatabaseUtils.prepareH2Connection("cards.h2", true));
            boolean isObsolete = RepositoryUtil.isDatabaseObsolete((ConnectionSource)connectionSource, VERSION_ENTITY_NAME, 5L);
            boolean isNewBuild = RepositoryUtil.isNewBuildRun((ConnectionSource)connectionSource, VERSION_ENTITY_NAME, ExpansionRepository.class);
            if (isObsolete || isNewBuild) {
                TableUtils.dropTable((ConnectionSource)connectionSource, ExpansionInfo.class, (boolean)true);
            }
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, ExpansionInfo.class);
            this.expansionDao = DaoManager.createDao((ConnectionSource)connectionSource, ExpansionInfo.class);
            this.instanceInitialized = true;
            this.eventSource.fireRepositoryDbLoaded();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void subscribe(Listener<RepositoryEvent> listener) {
        this.eventSource.addListener(listener);
    }

    public void unsubscribe(Listener<RepositoryEvent> listener) {
        this.eventSource.removeListener(listener);
    }

    public void saveSets(List<ExpansionInfo> newSets, List<ExpansionInfo> updatedSets, long newContentVersion) {
        try {
            this.expansionDao.callBatchTasks(() -> {
                if (newSets != null && !newSets.isEmpty()) {
                    logger.info((Object)("DB: need to add " + newSets.size() + " new sets"));
                    try {
                        for (ExpansionInfo exp : newSets) {
                            this.expansionDao.create((Object)exp);
                        }
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"Error adding expansions to DB - ", (Throwable)ex);
                    }
                }
                if (updatedSets != null && !updatedSets.isEmpty()) {
                    logger.info((Object)("DB: need to update " + updatedSets.size() + " sets"));
                    try {
                        for (ExpansionInfo exp : updatedSets) {
                            this.expansionDao.update((Object)exp);
                        }
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"Error adding expansions to DB - ", (Throwable)ex);
                    }
                }
                return null;
            });
            this.setContentVersion(newContentVersion);
            this.eventSource.fireRepositoryDbUpdated();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<String> getSetCodes() {
        ArrayList<String> setCodes = new ArrayList<String>();
        try {
            List expansions = this.expansionDao.queryForAll();
            for (ExpansionInfo expansion : expansions) {
                setCodes.add(expansion.getCode());
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"Can't get the expansion set codes from database.", (Throwable)ex);
            return setCodes;
        }
        return setCodes;
    }

    public ExpansionInfo[] getWithBoostersSortedByReleaseDate() {
        try {
            GenericRawResults setsList = this.expansionDao.queryRaw("select * from expansion e  where e.boosters = 1    and exists(select (1) from  card c where c.setcode = e.code)  order by e.releasedate desc", this.expansionDao.getRawRowMapper(), new String[0]);
            ArrayList<ExpansionInfo> resList = new ArrayList<ExpansionInfo>();
            for (ExpansionInfo info : setsList) {
                resList.add(info);
            }
            return resList.toArray(new ExpansionInfo[0]);
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            return new ExpansionInfo[0];
        }
    }

    public List<ExpansionInfo> getSetsWithBasicLandsByReleaseDate() {
        List<ExpansionInfo> sets = new LinkedList<ExpansionInfo>();
        try {
            QueryBuilder qb = this.expansionDao.queryBuilder();
            qb.orderBy("releaseDate", false);
            qb.where().eq("basicLands", (Object)new SelectArg((Object)true));
            sets = this.expansionDao.query(qb.prepare());
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
        }
        return sets;
    }

    public List<ExpansionInfo> getSetsFromBlock(String blockName) {
        LinkedList<ExpansionInfo> sets = new LinkedList<ExpansionInfo>();
        try {
            QueryBuilder qb = this.expansionDao.queryBuilder();
            qb.where().eq("blockName", (Object)new SelectArg((Object)blockName));
            return this.expansionDao.query(qb.prepare());
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            return sets;
        }
    }

    public ExpansionInfo getSetByCode(String setCode) {
        ExpansionInfo set = null;
        try {
            QueryBuilder qb = this.expansionDao.queryBuilder();
            qb.limit(Long.valueOf(1L)).where().eq("code", (Object)new SelectArg((Object)setCode));
            List expansions = this.expansionDao.query(qb.prepare());
            if (!expansions.isEmpty()) {
                set = (ExpansionInfo)expansions.get(0);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
        }
        return set;
    }

    public ExpansionInfo getSetByName(String setName) {
        ExpansionInfo set = null;
        try {
            QueryBuilder qb = this.expansionDao.queryBuilder();
            qb.limit(Long.valueOf(1L)).where().eq("name", (Object)new SelectArg((Object)setName));
            List expansions = this.expansionDao.query(qb.prepare());
            if (!expansions.isEmpty()) {
                set = (ExpansionInfo)expansions.get(0);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
        }
        return set;
    }

    public List<ExpansionInfo> getAll() {
        try {
            QueryBuilder qb = this.expansionDao.queryBuilder();
            qb.orderBy("releaseDate", true);
            return this.expansionDao.query(qb.prepare());
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            return Collections.emptyList();
        }
    }

    public long getContentVersionFromDB() {
        try {
            JdbcConnectionSource connectionSource = new JdbcConnectionSource(DatabaseUtils.prepareH2Connection("cards.h2", false));
            return RepositoryUtil.getDatabaseVersion((ConnectionSource)connectionSource, "expansionContent");
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return 0L;
        }
    }

    public void setContentVersion(long version) {
        try {
            JdbcConnectionSource connectionSource = new JdbcConnectionSource(DatabaseUtils.prepareH2Connection("cards.h2", false));
            RepositoryUtil.updateVersion((ConnectionSource)connectionSource, "expansionContent", version);
        }
        catch (SQLException e) {
            logger.error((Object)("Error setting content version - " + e), (Throwable)e);
        }
    }

    public long getContentVersionConstant() {
        return 18L;
    }

    static {
        logger = Logger.getLogger(ExpansionRepository.class);
    }
}

