/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.repository;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import java.sql.SQLException;
import java.util.List;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardRepository;
import mage.cards.repository.DatabaseBuild;
import mage.cards.repository.DatabaseVersion;
import mage.cards.repository.ExpansionRepository;
import mage.cards.repository.TokenRepository;
import mage.cards.repository.TokenType;
import mage.util.DebugUtil;
import mage.util.JarVersion;
import org.apache.log4j.Logger;

public final class RepositoryUtil {
    private static final Logger logger = Logger.getLogger(RepositoryUtil.class);
    public static final boolean CARD_DB_RECREATE_BY_CLIENT_SIDE = true;

    public static void bootstrapLocalDb() {
        logger.info((Object)"Loading database...");
        ExpansionRepository.instance.getContentVersionConstant();
        CardRepository.instance.getContentVersionConstant();
        TokenRepository.instance.getAll().size();
        int totalSets = ExpansionRepository.instance.getAll().size();
        int totalCards = CardRepository.instance.findCards(new CardCriteria().nightCard(false)).size() + CardRepository.instance.findCards(new CardCriteria().nightCard(true)).size();
        logger.info((Object)"Database stats:");
        logger.info((Object)(" - sets: " + (totalSets == 0 ? "updating" : Integer.valueOf(totalSets))));
        logger.info((Object)(" - cards: " + (totalCards == 0 ? "updating" : Integer.valueOf(totalCards))));
        logger.info((Object)(" - tokens: " + TokenRepository.instance.getByType(TokenType.TOKEN).size()));
        logger.info((Object)(" - emblems: " + TokenRepository.instance.getByType(TokenType.EMBLEM).size()));
        logger.info((Object)(" - planes: " + TokenRepository.instance.getByType(TokenType.PLANE).size()));
        logger.info((Object)(" - dungeons: " + TokenRepository.instance.getByType(TokenType.DUNGEON).size()));
        if (DebugUtil.DATABASE_SHOW_CACHE_AND_MEMORY_STATS_ON_STARTUP) {
            CardRepository.instance.printDatabaseStats("on startup");
        }
    }

    public static boolean isDatabaseObsolete(ConnectionSource connectionSource, String entityName, long version) throws SQLException {
        TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, DatabaseVersion.class);
        Dao versionDao = DaoManager.createDao((ConnectionSource)connectionSource, DatabaseVersion.class);
        QueryBuilder queryBuilder = versionDao.queryBuilder();
        queryBuilder.where().eq("entity", (Object)new SelectArg((Object)entityName)).and().eq("version", (Object)new SelectArg((Object)version));
        List dbVersions = versionDao.query(queryBuilder.prepare());
        if (dbVersions.isEmpty()) {
            DatabaseVersion dbVersion = new DatabaseVersion();
            dbVersion.setEntity(entityName);
            dbVersion.setVersion(version);
            versionDao.create((Object)dbVersion);
        }
        return dbVersions.isEmpty();
    }

    public static boolean isNewBuildRun(ConnectionSource connectionSource, String entityName, Class clazz) throws SQLException {
        String currentBuild = JarVersion.getBuildTime(clazz);
        if (!JarVersion.isBuildTimeOk(currentBuild)) {
            return false;
        }
        TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, DatabaseBuild.class);
        Dao buildDao = DaoManager.createDao((ConnectionSource)connectionSource, DatabaseBuild.class);
        QueryBuilder queryBuilder = buildDao.queryBuilder();
        queryBuilder.where().eq("entity", (Object)new SelectArg((Object)entityName)).and().eq("last_build", (Object)new SelectArg((Object)currentBuild));
        List dbBuilds = buildDao.query(queryBuilder.prepare());
        if (dbBuilds.isEmpty()) {
            DatabaseBuild dbBuild = new DatabaseBuild();
            dbBuild.setEntity(entityName);
            dbBuild.setLastBuild(currentBuild);
            buildDao.create((Object)dbBuild);
        }
        return dbBuilds.isEmpty();
    }

    public static void updateVersion(ConnectionSource connectionSource, String entityName, long version) throws SQLException {
        TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, DatabaseVersion.class);
        Dao versionDao = DaoManager.createDao((ConnectionSource)connectionSource, DatabaseVersion.class);
        QueryBuilder queryBuilder = versionDao.queryBuilder();
        queryBuilder.where().eq("entity", (Object)new SelectArg((Object)entityName));
        List dbVersions = versionDao.query(queryBuilder.prepare());
        if (!dbVersions.isEmpty()) {
            DeleteBuilder deleteBuilder = versionDao.deleteBuilder();
            deleteBuilder.where().eq("entity", (Object)new SelectArg((Object)entityName));
            deleteBuilder.delete();
        }
        DatabaseVersion databaseVersion = new DatabaseVersion();
        databaseVersion.setEntity(entityName);
        databaseVersion.setVersion(version);
        versionDao.create((Object)databaseVersion);
    }

    public static long getDatabaseVersion(ConnectionSource connectionSource, String entityName) throws SQLException {
        TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, DatabaseVersion.class);
        Dao versionDao = DaoManager.createDao((ConnectionSource)connectionSource, DatabaseVersion.class);
        QueryBuilder queryBuilder = versionDao.queryBuilder();
        queryBuilder.where().eq("entity", (Object)new SelectArg((Object)entityName));
        List dbVersions = versionDao.query(queryBuilder.prepare());
        if (dbVersions.isEmpty()) {
            return 0L;
        }
        return ((DatabaseVersion)dbVersions.get(0)).getVersion();
    }

    public static boolean isDatabaseEmpty() {
        return ExpansionRepository.instance.getSetByCode("GRN") == null || CardRepository.instance.findCard("Island") == null;
    }
}

