/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.repository;

import mage.cards.repository.TokenType;

public class TokenInfo {
    private final TokenType tokenType;
    private final String name;
    private final String setCode;
    private final Integer imageNumber;
    private final String classFileName;
    private String downloadUrl = "";

    public TokenInfo(TokenType tokenType, String name, String setCode, Integer imageNumber) {
        this(tokenType, name, setCode, imageNumber, "");
    }

    public TokenInfo(TokenType tokenType, String name, String setCode, Integer imageNumber, String classFileName) {
        this.tokenType = tokenType;
        this.name = name;
        this.setCode = setCode;
        this.imageNumber = imageNumber;
        this.classFileName = classFileName;
    }

    public String toString() {
        return String.format("%s - %s - %s - %d (%s)", new Object[]{this.tokenType, this.setCode, this.name, this.imageNumber, this.classFileName});
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public String getName() {
        return this.name;
    }

    public String getSetCode() {
        return this.setCode;
    }

    public Integer getImageNumber() {
        return this.imageNumber;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public TokenInfo withDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    public String getFullClassFileName() {
        String simpleName = this.classFileName.isEmpty() ? this.name.replaceAll("[^a-zA-Z0-9]", "") : this.classFileName;
        switch (this.tokenType) {
            case TOKEN: {
                return "mage.game.permanent.token." + simpleName;
            }
            case EMBLEM: {
                return "mage.game.command.emblems." + simpleName;
            }
            case PLANE: {
                return "mage.game.command.planes." + simpleName;
            }
            case DUNGEON: {
                return "mage.game.command.dungeons." + simpleName;
            }
            case XMAGE: {
                return this.classFileName;
            }
        }
        throw new IllegalStateException("Unknown token type: " + (Object)((Object)this.tokenType));
    }
}

