/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.repository;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.cards.repository.TokenInfo;
import mage.cards.repository.TokenType;
import mage.util.RandomUtil;
import org.apache.log4j.Logger;

public enum TokenRepository {
    instance;

    public static final String XMAGE_TOKENS_SET_CODE = "XMAGE";
    public static final String XMAGE_IMAGE_NAME_FACE_DOWN_MANUAL = "Face Down";
    public static final String XMAGE_IMAGE_NAME_FACE_DOWN_MANIFEST = "Manifest";
    public static final String XMAGE_IMAGE_NAME_FACE_DOWN_CLOAK = "Cloak";
    public static final String XMAGE_IMAGE_NAME_FACE_DOWN_MORPH = "Morph";
    public static final String XMAGE_IMAGE_NAME_FACE_DOWN_DISGUISE = "Disguise";
    public static final String XMAGE_IMAGE_NAME_FACE_DOWN_FORETELL = "Foretell";
    public static final String XMAGE_IMAGE_NAME_COPY = "Copy";
    public static final String XMAGE_IMAGE_NAME_CITY_BLESSING = "City's Blessing";
    public static final String XMAGE_IMAGE_NAME_DAY = "Day";
    public static final String XMAGE_IMAGE_NAME_NIGHT = "Night";
    public static final String XMAGE_IMAGE_NAME_THE_MONARCH = "The Monarch";
    public static final String XMAGE_IMAGE_NAME_RADIATION = "Radiation";
    public static final String XMAGE_IMAGE_NAME_THE_RING = "The Ring";
    public static final String XMAGE_IMAGE_NAME_HELPER_EMBLEM = "Helper Emblem";
    public static final String XMAGE_IMAGE_NAME_SPEED = "Speed";
    private static final Logger logger;
    private ArrayList<TokenInfo> allTokens = new ArrayList();
    private final Map<String, List<TokenInfo>> indexByClassName = new HashMap<String, List<TokenInfo>>();
    private final Map<TokenType, List<TokenInfo>> indexByType = new HashMap<TokenType, List<TokenInfo>>();

    public void init() {
        if (!this.allTokens.isEmpty()) {
            return;
        }
        this.allTokens = TokenRepository.loadMtgTokens();
        this.allTokens.addAll(TokenRepository.loadXmageTokens());
        this.allTokens.forEach(token -> {
            String needClass = token.getFullClassFileName();
            List<TokenInfo> list = this.indexByClassName.getOrDefault(needClass, null);
            if (list == null) {
                list = new ArrayList<TokenInfo>();
                this.indexByClassName.put(needClass, list);
            }
            list.add((TokenInfo)token);
            list = this.indexByType.getOrDefault((Object)token.getTokenType(), null);
            if (list == null) {
                list = new ArrayList();
                this.indexByType.put(token.getTokenType(), list);
            }
            list.add((TokenInfo)token);
        });
    }

    public List<TokenInfo> getAll() {
        this.init();
        return this.allTokens;
    }

    public Map<String, List<TokenInfo>> getAllByClassName() {
        this.init();
        return this.indexByClassName;
    }

    public List<TokenInfo> getByType(TokenType tokenType) {
        this.init();
        return this.indexByType.getOrDefault((Object)tokenType, new ArrayList());
    }

    public List<TokenInfo> getByClassName(String fullClassName) {
        this.init();
        return this.indexByClassName.getOrDefault(fullClassName, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<TokenInfo> loadMtgTokens() throws RuntimeException {
        String dbSource = "tokens-database.txt";
        ArrayList<TokenInfo> list = new ArrayList<TokenInfo>();
        InputStream in = TokenRepository.class.getClassLoader().getResourceAsStream(dbSource);
        if (in == null) {
            throw new RuntimeException("Tokens database: can't load resource file " + dbSource);
        }
        ArrayList<String> errorsList = new ArrayList<String>();
        try (InputStreamReader input = new InputStreamReader(in);
             BufferedReader reader = new BufferedReader(input);){
            String line = reader.readLine();
            while (line != null) {
                try {
                    if (!(line = line.trim()).startsWith("|")) continue;
                    List params = Arrays.stream(line.split("\\|", -1)).map(String::trim).collect(Collectors.toList());
                    if (params.size() < 5) {
                        errorsList.add("Tokens database: wrong params count: " + line);
                        continue;
                    }
                    if (!((String)params.get(1)).toLowerCase(Locale.ENGLISH).equals("generate")) {
                        errorsList.add("Tokens database: miss generate param: " + line);
                        continue;
                    }
                    int imageNumber = 0;
                    if (!((String)params.get(4)).isEmpty()) {
                        imageNumber = Integer.parseInt((String)params.get(4));
                    }
                    String tokenClassName = "";
                    if (params.size() > 7 && !((String)params.get(6)).isEmpty()) {
                        tokenClassName = (String)params.get(6);
                    }
                    if (tokenClassName.isEmpty()) {
                        errorsList.add("Tokens database: miss class name: " + line);
                        continue;
                    }
                    String objectType = (String)params.get(2);
                    String tokenName = (String)params.get(3);
                    String setCode = "";
                    TokenType tokenType = null;
                    if (objectType.startsWith("TOK:")) {
                        setCode = objectType.substring("TOK:".length());
                        tokenType = TokenType.TOKEN;
                    }
                    if (objectType.startsWith("EMBLEM:")) {
                        setCode = objectType.substring("EMBLEM:".length());
                        tokenType = TokenType.EMBLEM;
                        if (!tokenName.startsWith("Emblem ")) {
                            errorsList.add("Tokens database: emblem's name must start with [Emblem ...] word: " + line);
                            continue;
                        }
                        if (!tokenClassName.endsWith("Emblem")) {
                            errorsList.add("Tokens database: emblem's class name must ends with [...Emblem] word: " + line);
                            continue;
                        }
                    }
                    if (objectType.startsWith("PLANE:")) {
                        setCode = objectType.substring("PLANE:".length());
                        tokenType = TokenType.PLANE;
                        if (!tokenName.startsWith("Plane - ")) {
                            errorsList.add("Tokens database: plane's name must start with [Plane - ...] word: " + line);
                            continue;
                        }
                        if (!tokenClassName.endsWith("Plane")) {
                            errorsList.add("Tokens database: plane's class name must ends with [...Plane] word: " + line);
                            continue;
                        }
                    }
                    if (objectType.startsWith("DUNGEON:")) {
                        setCode = objectType.substring("DUNGEON:".length());
                        tokenType = TokenType.DUNGEON;
                        if (!tokenClassName.endsWith("Dungeon")) {
                            errorsList.add("Tokens database: dungeon's class name must ends with [...Dungeon] word: " + line);
                            continue;
                        }
                    }
                    if (tokenType == null) {
                        errorsList.add("Tokens database: unknown line format: " + line);
                        continue;
                    }
                    TokenInfo token = new TokenInfo(tokenType, tokenName, setCode, imageNumber, tokenClassName);
                    list.add(token);
                }
                finally {
                    line = reader.readLine();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Tokens database: can't read data, unknown error - " + e.getMessage());
        }
        if (!errorsList.isEmpty()) {
            errorsList.forEach(arg_0 -> ((Logger)logger).error(arg_0));
            throw new RuntimeException(String.format("Tokens database: found %d errors, see logs above for details", errorsList.size()));
        }
        return list;
    }

    public Map<String, String> prepareScryfallDownloadList() {
        this.init();
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        this.allTokens.stream().filter(token -> token.getTokenType().equals((Object)TokenType.XMAGE)).forEach(token -> {
            String code = String.format("%s/%s/%d", token.getSetCode(), token.getName(), token.getImageNumber());
            res.put(code, token.getDownloadUrl());
        });
        return res;
    }

    private static TokenInfo createXmageToken(String name, Integer imageNumber, String scryfallDownloadUrl) {
        return new TokenInfo(TokenType.XMAGE, name, XMAGE_TOKENS_SET_CODE, imageNumber).withDownloadUrl(scryfallDownloadUrl);
    }

    private static ArrayList<TokenInfo> loadXmageTokens() {
        ArrayList<TokenInfo> res = new ArrayList<TokenInfo>();
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_FACE_DOWN_MANUAL, 1, "https://upload.wikimedia.org/wikipedia/en/a/aa/Magic_the_gathering-card_back.jpg"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_COPY, 1, "https://api.scryfall.com/cards/tclb/19/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_COPY, 2, "https://api.scryfall.com/cards/tsnc/1/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_COPY, 3, "https://api.scryfall.com/cards/tvow/19/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_COPY, 4, "https://api.scryfall.com/cards/tznr/12/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_COPY, 5, "https://api.scryfall.com/cards/twho/1/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_COPY, 6, "https://api.scryfall.com/cards/tlci/1/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_COPY, 7, "https://api.scryfall.com/cards/tfin/1/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_COPY, 8, "https://api.scryfall.com/cards/ttdm/1/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_COPY, 9, "https://api.scryfall.com/cards/totj/1/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_COPY, 10, "https://api.scryfall.com/cards/tdsk/1/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_COPY, 11, "https://api.scryfall.com/cards/tacr/1/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_COPY, 12, "https://api.scryfall.com/cards/tpip/1/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_COPY, 13, "https://api.scryfall.com/cards/teoc/1/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_COPY, 14, "https://api.scryfall.com/cards/tspm/1/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_CITY_BLESSING, 1, "https://api.scryfall.com/cards/f18/2/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_CITY_BLESSING, 2, "https://api.scryfall.com/cards/tlcc/17/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_CITY_BLESSING, 3, "https://api.scryfall.com/cards/tmkc/28/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_DAY, 1, "https://api.scryfall.com/cards/tvow/21/en?format=image&face=front"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_NIGHT, 1, "https://api.scryfall.com/cards/tvow/21/en?format=image&face=back"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_FACE_DOWN_MANIFEST, 1, "https://api.scryfall.com/cards/tc19/28/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_FACE_DOWN_MANIFEST, 2, "https://api.scryfall.com/cards/tc18/1/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_FACE_DOWN_MANIFEST, 3, "https://api.scryfall.com/cards/tfrf/4/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_FACE_DOWN_MANIFEST, 4, "https://api.scryfall.com/cards/tncc/3/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_FACE_DOWN_MANIFEST, 5, "https://api.scryfall.com/cards/tdsk/18/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_FACE_DOWN_MORPH, 1, "https://api.scryfall.com/cards/tktk/11/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_FACE_DOWN_MORPH, 2, "https://api.scryfall.com/cards/ta25/15/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_FACE_DOWN_MORPH, 3, "https://api.scryfall.com/cards/tc19/27/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_FACE_DOWN_DISGUISE, 1, "https://api.scryfall.com/cards/tmkm/21/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_FACE_DOWN_CLOAK, 1, "https://api.scryfall.com/cards/tmkm/21/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_FACE_DOWN_FORETELL, 1, "https://api.scryfall.com/cards/tkhm/23/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_FACE_DOWN_FORETELL, 2, "https://api.scryfall.com/cards/tfic/10/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_THE_MONARCH, 1, "https://api.scryfall.com/cards/tonc/22/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_THE_MONARCH, 2, "https://api.scryfall.com/cards/tcn2/1/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_THE_MONARCH, 3, "https://api.scryfall.com/cards/tltc/15/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_THE_MONARCH, 4, "https://api.scryfall.com/cards/tfic/11/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_RADIATION, 1, "https://api.scryfall.com/cards/tpip/22/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_THE_RING, 1, "https://api.scryfall.com/cards/tltr/H13/en?format=image"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_SPEED, 1, "https://api.scryfall.com/cards/tdft/14/en?format=image&&face=back"));
        res.add(TokenRepository.createXmageToken(XMAGE_IMAGE_NAME_HELPER_EMBLEM, 1, "https://upload.wikimedia.org/wikipedia/en/a/aa/Magic_the_gathering-card_back.jpg"));
        return res;
    }

    private TokenInfo findPreferredTokenInfo(List<TokenInfo> possibleList, String preferredSetCode) {
        List<Object> needList = possibleList.stream().filter(info -> info.getSetCode().equals(preferredSetCode)).collect(Collectors.toList());
        if (needList.isEmpty()) {
            needList = possibleList;
        }
        if (needList.size() > 0) {
            return (TokenInfo)RandomUtil.randomFromCollection(needList);
        }
        return null;
    }

    public TokenInfo findPreferredTokenInfoForClass(String className, String preferredSetCode) {
        return this.findPreferredTokenInfo(instance.getByClassName(className), preferredSetCode);
    }

    public TokenInfo findPreferredTokenInfoForXmage(String name, UUID randomFromId) {
        List needList = instance.getByType(TokenType.XMAGE).stream().filter(info -> info.getName().equals(name)).collect(Collectors.toList());
        if (needList.isEmpty()) {
            return null;
        }
        if (needList.size() == 1) {
            return (TokenInfo)needList.get(0);
        }
        if (randomFromId == null) {
            return (TokenInfo)RandomUtil.randomFromCollection(needList);
        }
        int itemIndex = new Random(randomFromId.getLeastSignificantBits()).nextInt(needList.size());
        return (TokenInfo)needList.get(itemIndex);
    }

    static {
        logger = Logger.getLogger(TokenRepository.class);
    }
}

