/*
 * Decompiled with CFR 0.152.
 */
package mage.constants;

import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.hint.common.ArtifactYouControlHint;
import mage.abilities.hint.common.CreaturesYouControlHint;
import mage.abilities.hint.common.GatesYouControlHint;
import mage.constants.AffinityFilters;
import mage.constants.SubType;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledEnchantmentPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterControlledPlaneswalkerPermanent;
import mage.util.CardUtil;

public enum AffinityType {
    ARTIFACTS((FilterControlledPermanent)new FilterControlledArtifactPermanent("artifacts"), ArtifactYouControlHint.instance),
    CREATURES((FilterControlledPermanent)new FilterControlledCreaturePermanent("creatures"), CreaturesYouControlHint.instance),
    ARTIFACT_CREATURES(AffinityFilters.ARTIFACT_CREATURES),
    ENCHANTMENTS(new FilterControlledEnchantmentPermanent("enchantments")),
    PLANESWALKERS(new FilterControlledPlaneswalkerPermanent("planeswalker")),
    EQUIPMENT(new FilterControlledPermanent(SubType.EQUIPMENT, "Equipment"), "Equipment"),
    AURAS(new FilterControlledPermanent(SubType.AURA, "Auras")),
    FOOD(new FilterControlledPermanent(SubType.FOOD, "Food"), "Food"),
    TOKENS(AffinityFilters.TOKENS),
    PLAINS(new FilterControlledPermanent(SubType.PLAINS, "Plains")),
    ISLANDS(new FilterControlledPermanent(SubType.ISLAND, "Islands")),
    SWAMPS(new FilterControlledPermanent(SubType.SWAMP, "Swamps")),
    MOUNTAINS(new FilterControlledPermanent(SubType.MOUNTAIN, "Mountains")),
    FORESTS(new FilterControlledPermanent(SubType.FOREST, "Forests")),
    SPIRITS(new FilterControlledPermanent(SubType.SPIRIT, "Spirits")),
    HUMANS(new FilterControlledPermanent(SubType.HUMAN, "Humans")),
    KNIGHTS(new FilterControlledPermanent(SubType.KNIGHT, "Knights")),
    DALEKS(new FilterControlledPermanent(SubType.DALEK, "Daleks")),
    FROGS(new FilterControlledPermanent(SubType.FROG, "Frogs")),
    LIZARDS(new FilterControlledPermanent(SubType.LIZARD, "Lizards")),
    BIRDS(new FilterControlledPermanent(SubType.BIRD, "Birds")),
    CITIZENS(new FilterControlledPermanent(SubType.CITIZEN, "Citizens")),
    SLIVERS(new FilterControlledPermanent(SubType.SLIVER, "Slivers")),
    TOWNS(new FilterControlledPermanent(SubType.TOWN, "Towns")),
    GATES(new FilterControlledPermanent(SubType.GATE, "Gates"), GatesYouControlHint.instance),
    SNOW_LANDS(AffinityFilters.SNOW_LANDS),
    HISTORIC(AffinityFilters.HISTORIC),
    OUTLAWS(AffinityFilters.OUTLAWS);

    private final FilterControlledPermanent filter;
    private final Hint hint;
    private final String singularName;

    private AffinityType(FilterControlledPermanent filter) {
        this(filter, filter.getMessage());
    }

    private AffinityType(FilterControlledPermanent filter, String singularName) {
        this(filter, new ValueHint(CardUtil.getTextWithFirstCharUpperCase(filter.getMessage()) + " you control", new PermanentsOnBattlefieldCount(filter)), singularName);
    }

    private AffinityType(FilterControlledPermanent filter, Hint hint) {
        this(filter, hint, filter.getMessage().substring(0, filter.getMessage().length() - 1));
    }

    private AffinityType(FilterControlledPermanent filter, Hint hint, String singularName) {
        this.filter = filter;
        this.hint = hint;
        this.singularName = singularName;
    }

    public FilterControlledPermanent getFilter() {
        return this.filter;
    }

    public Hint getHint() {
        return this.hint;
    }

    public String getSingularName() {
        return this.singularName;
    }
}

