/*
 * Decompiled with CFR 0.152.
 */
package mage.constants;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.game.Game;

public enum ModeChoice {
    KHANS("Khans"),
    DRAGONS("Dragons"),
    MARDU("Mardu"),
    TEMUR("Temur"),
    ABZAN("Abzan"),
    JESKAI("Jeskai"),
    SULTAI("Sultai"),
    MIRRAN("Mirran"),
    PHYREXIAN("Phyrexian"),
    ODD("odd"),
    EVEN("even"),
    BELIEVE("Believe"),
    DOUBT("Doubt"),
    NCR("NCR"),
    LEGION("Legion"),
    BROTHERHOOD("Brotherhood"),
    ENCLAVE("Enclave"),
    ISLAND("Island"),
    SWAMP("Swamp"),
    LEFT("left"),
    RIGHT("right");

    private final String name;
    private final ModeChoiceCondition condition;

    private ModeChoice(String name) {
        this.name = name;
        this.condition = new ModeChoiceCondition(this);
    }

    public String toString() {
        return this.name;
    }

    public ModeChoiceCondition getCondition() {
        return this.condition;
    }

    public boolean checkMode(Game game, Ability source) {
        return Objects.equals(game.getState().getValue(source.getSourceId() + "_modeChoice"), this.name);
    }

    private static class ModeChoiceCondition
    implements Condition {
        private final ModeChoice modeChoice;

        ModeChoiceCondition(ModeChoice modeChoice) {
            this.modeChoice = modeChoice;
        }

        @Override
        public boolean apply(Game game, Ability source) {
            return this.modeChoice.checkMode(game, source);
        }
    }
}

