/*
 * Decompiled with CFR 0.152.
 */
package mage.counters;

import java.io.Serializable;
import mage.counters.CounterType;
import mage.util.CardUtil;
import mage.util.Copyable;
import org.apache.log4j.Logger;

public class Counter
implements Serializable,
Copyable<Counter> {
    private static final Logger logger = Logger.getLogger(Counter.class);
    protected final String name;
    protected int count;

    public Counter(String name) {
        this.name = name;
        this.count = 1;
    }

    public Counter(String name, int count) {
        this.name = name;
        this.count = count;
    }

    protected Counter(Counter counter) {
        this.name = counter.name;
        this.count = counter.count;
    }

    public void add(int amount) {
        this.count += amount;
    }

    public void remove(int amount) {
        if (this.count >= amount) {
            this.count -= amount;
        } else {
            logger.warn((Object)("An attempt was made to set the counter '" + this.name + "' to less than 0. Setting to 0."));
            this.count = 0;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getCount() {
        return this.count;
    }

    public String getDescription() {
        return CardUtil.getSimpleCountersText(Math.max(this.count, 1), CounterType.findArticle(this.name), this.name);
    }

    @Override
    public Counter copy() {
        return new Counter(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Counter counter = (Counter)o;
        return this.count == counter.count && !(this.name == null ? counter.name != null : !this.name.equals(counter.name));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.count;
        return result;
    }
}

