/*
 * Decompiled with CFR 0.152.
 */
package mage.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.SubType;
import mage.filter.FilterInPlay;
import mage.filter.FilterObject;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class FilterPermanent
extends FilterObject<Permanent>
implements FilterInPlay<Permanent> {
    protected final List<ObjectSourcePlayerPredicate<Permanent>> extraPredicates = new ArrayList<ObjectSourcePlayerPredicate<Permanent>>();

    public FilterPermanent() {
        super("permanent");
    }

    public FilterPermanent(String name) {
        super(name);
    }

    public FilterPermanent(SubType subtype, String name) {
        super(name);
        this.add(subtype.getPredicate());
    }

    public FilterPermanent(Set<SubType> subtypesList, String name) {
        super(name);
        for (SubType subtype : subtypesList) {
            this.add(subtype.getPredicate());
        }
    }

    protected FilterPermanent(FilterPermanent filter) {
        super(filter);
        this.extraPredicates.addAll(filter.extraPredicates);
    }

    @Override
    public boolean checkObjectClass(Object object) {
        return object instanceof Permanent;
    }

    @Override
    public boolean match(Permanent permanent, UUID playerId, Ability source, Game game) {
        if (!this.match(permanent, game) || !permanent.isPhasedIn()) {
            return false;
        }
        ObjectSourcePlayer<Permanent> osp = new ObjectSourcePlayer<Permanent>(permanent, playerId, source);
        return this.extraPredicates.stream().allMatch(p -> p.apply(osp, game));
    }

    public final void add(ObjectSourcePlayerPredicate predicate) {
        if (this.isLockedFilter()) {
            throw new UnsupportedOperationException("You may not modify a locked filter");
        }
        Predicates.makeSurePredicateCompatibleWithFilter(predicate, Permanent.class);
        this.extraPredicates.add(predicate);
    }

    @Override
    public FilterPermanent copy() {
        return new FilterPermanent(this);
    }

    @Override
    public List<Predicate> getExtraPredicates() {
        return new ArrayList<Predicate>(this.extraPredicates);
    }
}

