/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.predicate.card;

import java.util.UUID;
import mage.cards.Card;
import mage.filter.Filter;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

public class AuraCardCanAttachToLKIPermanentId
implements Predicate<Card> {
    private final UUID toBeCheckedLKIPermanentId;

    public AuraCardCanAttachToLKIPermanentId(UUID toBeCheckedLKIPermanentId) {
        this.toBeCheckedLKIPermanentId = toBeCheckedLKIPermanentId;
    }

    @Override
    public boolean apply(Card input, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(this.toBeCheckedLKIPermanentId);
        for (Target target : input.getSpellAbility().getTargets()) {
            Filter filter = target.getFilter();
            if (!filter.match(permanent, game)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "AuraCardCanAttachToLKIPermanentId(" + this.toBeCheckedLKIPermanentId + ')';
    }
}

