/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.predicate.mageobject;

import java.util.Optional;
import mage.MageObject;
import mage.constants.ComparisonType;
import mage.counters.CounterType;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;

public class ManaValueCompareToCountersSourceCountPredicate
implements ObjectSourcePlayerPredicate<MageObject> {
    private final CounterType counterType;
    private final ComparisonType comparisonType;

    public ManaValueCompareToCountersSourceCountPredicate(CounterType counterType, ComparisonType comparisonType) {
        this.counterType = counterType;
        this.comparisonType = comparisonType;
    }

    @Override
    public boolean apply(ObjectSourcePlayer<MageObject> input, Game game) {
        int counterCount = Optional.ofNullable(input.getSource().getSourcePermanentOrLKI(game)).map(permanent -> permanent.getCounters(game)).map(counters -> counters.getCount(this.counterType)).orElse(-1);
        return ComparisonType.compare(input.getObject().getManaValue(), this.comparisonType, counterCount);
    }

    public String toString() {
        return "mana value " + this.comparisonType.toString() + " to the number of " + this.counterType.getName() + " counters on {this}";
    }
}

