/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.predicate.mageobject;

import mage.MageObject;
import mage.cards.CardWithHalves;
import mage.cards.SplitCard;
import mage.constants.SpellAbilityType;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.util.CardUtil;

public class NamePredicate
implements Predicate<MageObject> {
    private final String name;
    private final Boolean ignoreMtgRuleForEmptyNames;

    public NamePredicate(String name) {
        this(name, false);
    }

    public NamePredicate(String name, Boolean ignoreMtgRuleForEmptyNames) {
        this.name = name;
        this.ignoreMtgRuleForEmptyNames = ignoreMtgRuleForEmptyNames;
    }

    @Override
    public boolean apply(MageObject input, Game game) {
        if (this.name == null) {
            return false;
        }
        if (input instanceof SplitCard) {
            return CardUtil.haveSameNames(this.name, ((CardWithHalves)input).getLeftHalfCard().getName(), this.ignoreMtgRuleForEmptyNames) || CardUtil.haveSameNames(this.name, ((CardWithHalves)input).getRightHalfCard().getName(), this.ignoreMtgRuleForEmptyNames) || CardUtil.haveSameNames(this.name, input.getName(), this.ignoreMtgRuleForEmptyNames);
        }
        if (input instanceof Spell && ((Spell)input).getSpellAbility().getSpellAbilityType() == SpellAbilityType.SPLIT_FUSED) {
            SplitCard card = (SplitCard)((Spell)input).getCard();
            return CardUtil.haveSameNames(this.name, card.getLeftHalfCard().getName(), this.ignoreMtgRuleForEmptyNames) || CardUtil.haveSameNames(this.name, card.getRightHalfCard().getName(), this.ignoreMtgRuleForEmptyNames) || CardUtil.haveSameNames(this.name, card.getName(), this.ignoreMtgRuleForEmptyNames);
        }
        if (input instanceof Spell && ((Spell)input).isFaceDown(game)) {
            return false;
        }
        if (this.name.contains(" // ")) {
            String leftName = this.name.substring(0, this.name.indexOf(" // "));
            String rightName = this.name.substring(this.name.indexOf(" // ") + 4);
            return CardUtil.haveSameNames(leftName, input.getName(), this.ignoreMtgRuleForEmptyNames) || CardUtil.haveSameNames(rightName, input.getName(), this.ignoreMtgRuleForEmptyNames);
        }
        return CardUtil.haveSameNames(this.name, input.getName(), this.ignoreMtgRuleForEmptyNames);
    }

    public String toString() {
        return "Name (" + this.name + ')';
    }
}

