/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.predicate.other;

import java.util.UUID;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.util.TargetAddress;

public class HasOnlySingleTargetPermanentPredicate
implements ObjectSourcePlayerPredicate<Spell> {
    private final FilterPermanent filter;

    public HasOnlySingleTargetPermanentPredicate(FilterPermanent filter) {
        this.filter = filter.copy();
    }

    @Override
    public boolean apply(ObjectSourcePlayer<Spell> input, Game game) {
        Spell spell = input.getObject();
        if (spell == null) {
            return false;
        }
        UUID singleTarget = null;
        for (TargetAddress addr : TargetAddress.walk(spell)) {
            Target targetInstance = addr.getTarget(spell);
            for (UUID targetId : targetInstance.getTargets()) {
                if (singleTarget == null) {
                    singleTarget = targetId;
                    continue;
                }
                if (singleTarget.equals(targetId)) continue;
                return false;
            }
        }
        if (singleTarget == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(singleTarget);
        return this.filter.match(permanent, input.getPlayerId(), input.getSource(), game);
    }

    public String toString() {
        return "that targets only a single " + this.filter.getMessage();
    }
}

