/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.predicate.permanent;

import java.util.UUID;
import mage.filter.Filter;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

public class AuraPermanentCanAttachToPermanentId
implements Predicate<Permanent> {
    private final UUID toBeCheckedPermanentId;

    public AuraPermanentCanAttachToPermanentId(UUID toBeCheckedPermanentId) {
        this.toBeCheckedPermanentId = toBeCheckedPermanentId;
    }

    @Override
    public boolean apply(Permanent input, Game game) {
        Permanent permanent = game.getPermanent(this.toBeCheckedPermanentId);
        if (input.getSpellAbility() != null && input.getSpellAbility().getTargets() != null) {
            for (Target target : input.getSpellAbility().getTargets()) {
                Filter filter = target.getFilter();
                if (!filter.match(permanent, game)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "AuraPermanentCanAttachToPermanentId(" + this.toBeCheckedPermanentId + ')';
    }
}

