/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.filter.FilterCard;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.Copyable;

public class Exile
implements Serializable,
Copyable<Exile> {
    private static final UUID PERMANENT = UUID.randomUUID();
    private final Map<UUID, ExileZone> exileZones = new HashMap<UUID, ExileZone>();

    public Exile() {
        this.createZone(PERMANENT, "Permanent");
    }

    protected Exile(Exile exile) {
        for (Map.Entry<UUID, ExileZone> entry : exile.exileZones.entrySet()) {
            this.exileZones.put(entry.getKey(), entry.getValue().copy());
        }
    }

    public Collection<ExileZone> getExileZones() {
        return this.exileZones.values();
    }

    public ExileZone getPermanentExile() {
        return this.exileZones.get(PERMANENT);
    }

    public void add(UUID id, String name, Card card) {
        this.createZone(id, name).add(card);
    }

    public void add(Card card) {
        this.exileZones.get(PERMANENT).add(card);
    }

    public ExileZone createZone(UUID id, String name) {
        return this.exileZones.computeIfAbsent(id, x -> new ExileZone(id, name + " - Exile"));
    }

    public ExileZone getExileZone(UUID id) {
        return this.exileZones.get(id);
    }

    public Card getCard(UUID cardId, Game game) {
        for (ExileZone exile : this.exileZones.values()) {
            if (!exile.contains(cardId)) continue;
            return game.getCard(cardId);
        }
        return null;
    }

    @Deprecated
    public List<Card> getCards(FilterCard filter, Game game) {
        List<Card> allCards = this.getAllCards(game);
        return allCards.stream().filter(card -> filter.match((Card)card, game)).collect(Collectors.toList());
    }

    @Deprecated
    public List<Card> getAllCards(Game game) {
        return this.getCardsOwned(game, null);
    }

    public List<Card> getCardsOwned(Game game, UUID ownerId) {
        ArrayList<Card> res = new ArrayList<Card>();
        for (ExileZone exile : this.exileZones.values()) {
            for (Card card : exile.getCards(game)) {
                if (ownerId != null && !card.isOwnedBy(ownerId)) continue;
                res.add(card);
            }
        }
        return res;
    }

    public Set<Card> getCardsOwned(FilterCard filter, UUID playerId, Ability source, Game game) {
        return this.getCardsOwned(game, playerId).stream().filter(card -> filter.match((Card)card, playerId, source, game)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public List<Card> getCardsInRange(Game game, UUID controllerId) {
        ArrayList<Card> res = new ArrayList<Card>();
        for (UUID playerId : game.getState().getPlayersInRange(controllerId, game)) {
            res.addAll(this.getCardsOwned(game, playerId));
        }
        return res;
    }

    public Set<Card> getCardsInRange(FilterCard filter, UUID playerId, Ability source, Game game) {
        return this.getCardsInRange(game, playerId).stream().filter(card -> filter.match((Card)card, playerId, source, game)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public boolean removeCard(Card card) {
        for (ExileZone exile : this.exileZones.values()) {
            if (!exile.contains(card.getId())) continue;
            return exile.remove(card.getId());
        }
        return false;
    }

    public void moveToAnotherZone(Card card, Game game, ExileZone exileZone) {
        if (this.getCard(card.getId(), game) == null) {
            throw new IllegalArgumentException("Card must be in exile zone: " + card.getIdName());
        }
        if (exileZone == null) {
            throw new IllegalArgumentException("Exile zone must exists: " + card.getIdName());
        }
        this.removeCard(card);
        exileZone.add(card);
    }

    public void moveToMainExileZone(Card card, Game game) {
        this.moveToAnotherZone(card, game, this.getExileZone(PERMANENT));
    }

    @Override
    public Exile copy() {
        return new Exile(this);
    }

    public boolean containsId(UUID cardId, Game game) {
        for (Card card : this.getAllCards(game)) {
            if (!card.getId().equals(cardId)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        for (ExileZone exile : this.exileZones.values()) {
            exile.clear();
        }
    }

    public void cleanupEndOfTurnZones(Game game) {
        ExileZone mainZone = this.getExileZone(PERMANENT);
        for (ExileZone zone : this.exileZones.values()) {
            if (!zone.isCleanupOnEndTurn()) continue;
            for (Card card : zone.getCards(game)) {
                mainZone.add(card);
                zone.remove(card);
            }
        }
    }

    public String toString() {
        return "Cards: " + this.exileZones.values().stream().mapToInt(HashSet::size).sum();
    }
}

