/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.DelayedTriggeredAbilities;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.MageSingleton;
import mage.abilities.Mode;
import mage.abilities.SpecialActions;
import mage.abilities.StaticAbility;
import mage.abilities.TriggeredAbilities;
import mage.abilities.TriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ContinuousEffects;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.CardWithSpellOption;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.cards.SpellOptionCard;
import mage.cards.SplitCard;
import mage.cards.SplitCardHalf;
import mage.cards.SubCard;
import mage.constants.PhaseStep;
import mage.constants.TurnPhase;
import mage.constants.Zone;
import mage.designations.Designation;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.CardState;
import mage.game.Controllable;
import mage.game.Exile;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.LookedAt;
import mage.game.MageObjectAttribute;
import mage.game.Revealed;
import mage.game.ZonesHandler;
import mage.game.combat.Combat;
import mage.game.combat.CombatGroup;
import mage.game.command.Command;
import mage.game.command.CommandObject;
import mage.game.command.Emblem;
import mage.game.command.Plane;
import mage.game.events.DamagedBatchAllEvent;
import mage.game.events.DamagedBatchBySourceEvent;
import mage.game.events.DamagedBatchCouldHaveFiredEvent;
import mage.game.events.DamagedBatchForOnePermanentEvent;
import mage.game.events.DamagedBatchForOnePlayerEvent;
import mage.game.events.DamagedBatchForPermanentsEvent;
import mage.game.events.DamagedBatchForPlayersEvent;
import mage.game.events.DamagedEvent;
import mage.game.events.DamagedPermanentEvent;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.events.LifeLostBatchEvent;
import mage.game.events.LifeLostBatchForOnePlayerEvent;
import mage.game.events.LifeLostEvent;
import mage.game.events.MilledBatchAllEvent;
import mage.game.events.MilledBatchForOnePlayerEvent;
import mage.game.events.MilledCardEvent;
import mage.game.events.SacrificedPermanentBatchEvent;
import mage.game.events.SacrificedPermanentEvent;
import mage.game.events.TappedBatchEvent;
import mage.game.events.TappedEvent;
import mage.game.events.UntappedBatchEvent;
import mage.game.events.UntappedEvent;
import mage.game.events.ZoneChangeBatchEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.events.ZoneChangeGroupEvent;
import mage.game.permanent.Battlefield;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.game.permanent.PermanentToken;
import mage.game.stack.SpellStack;
import mage.game.stack.StackObject;
import mage.game.turn.Phase;
import mage.game.turn.Step;
import mage.game.turn.Turn;
import mage.game.turn.TurnMods;
import mage.players.Player;
import mage.players.PlayerList;
import mage.players.Players;
import mage.target.Target;
import mage.util.CardUtil;
import mage.util.Copyable;
import mage.util.ThreadLocalStringBuilder;
import mage.watchers.Watcher;
import mage.watchers.Watchers;
import org.apache.log4j.Logger;

public class GameState
implements Serializable,
Copyable<GameState> {
    private static final Logger logger = Logger.getLogger(GameState.class);
    private static final ThreadLocalStringBuilder threadLocalBuilder = new ThreadLocalStringBuilder(1024);
    public static final String COPIED_CARD_KEY = "CopiedCard";
    private final Players players;
    private final PlayerList playerList;
    private UUID choosingPlayerId;
    private final Revealed revealed;
    private final Map<UUID, LookedAt> lookedAt = new HashMap<UUID, LookedAt>();
    private final Revealed companion;
    private SpecialActions specialActions;
    private Watchers watchers;
    private Turn turn;
    private TurnMods turnMods;
    private UUID activePlayerId;
    private UUID priorityPlayerId;
    private UUID playerByOrderId;
    private UUID monarchId;
    private UUID initiativeId;
    private SpellStack stack;
    private Command command;
    private boolean isPlaneChase;
    private List<String> seenPlanes = new ArrayList<String>();
    private List<Designation> designations = new ArrayList<Designation>();
    private List<Emblem> helperEmblems = new ArrayList<Emblem>();
    private Exile exile;
    private Battlefield battlefield;
    private int turnNum = 1;
    private int stepNum = 0;
    private UUID extraTurnId = null;
    private boolean gameOver;
    private boolean paused;
    private ContinuousEffects effects;
    private TriggeredAbilities triggers;
    private DelayedTriggeredAbilities delayed;
    private List<TriggeredAbility> triggered = new ArrayList<TriggeredAbility>();
    private Combat combat;
    private Map<String, Object> values = new HashMap<String, Object>();
    private Map<UUID, Zone> zones = new HashMap<UUID, Zone>();
    private List<GameEvent> simultaneousEvents = new ArrayList<GameEvent>();
    private Map<UUID, CardState> cardState = new HashMap<UUID, CardState>();
    private Map<MageObjectReference, Map<String, Object>> permanentCostsTags = new HashMap<MageObjectReference, Map<String, Object>>();
    private Map<UUID, MageObjectAttribute> mageObjectAttribute = new HashMap<UUID, MageObjectAttribute>();
    private Map<UUID, Integer> zoneChangeCounter = new HashMap<UUID, Integer>();
    private Map<UUID, Card> copiedCards = new HashMap<UUID, Card>();
    private int permanentOrderNumber;
    private final Map<UUID, FilterCreaturePermanent> usePowerInsteadOfToughnessForDamageLethalityFilters = new HashMap<UUID, FilterCreaturePermanent>();
    private Set<MageObjectReference> commandersToStay = new HashSet<MageObjectReference>();
    private boolean manaBurn = false;
    private boolean hasDayNight = false;
    private boolean isDaytime = true;
    private boolean reverseTurnOrder = false;
    private int applyEffectsCounter;

    public GameState() {
        this.players = new Players();
        this.playerList = new PlayerList();
        this.turn = new Turn();
        this.stack = new SpellStack();
        this.command = new Command();
        this.exile = new Exile();
        this.revealed = new Revealed();
        this.companion = new Revealed();
        this.battlefield = new Battlefield();
        this.effects = new ContinuousEffects();
        this.triggers = new TriggeredAbilities();
        this.delayed = new DelayedTriggeredAbilities();
        this.specialActions = new SpecialActions();
        this.combat = new Combat();
        this.turnMods = new TurnMods();
        this.watchers = new Watchers();
        this.applyEffectsCounter = 0;
    }

    protected GameState(GameState state) {
        this.players = state.players.copy();
        this.playerList = state.playerList.copy();
        this.choosingPlayerId = state.choosingPlayerId;
        this.revealed = state.revealed.copy();
        this.lookedAt.putAll(state.lookedAt);
        this.companion = state.companion.copy();
        this.gameOver = state.gameOver;
        this.paused = state.paused;
        this.activePlayerId = state.activePlayerId;
        this.priorityPlayerId = state.priorityPlayerId;
        this.playerByOrderId = state.playerByOrderId;
        this.monarchId = state.monarchId;
        this.initiativeId = state.initiativeId;
        this.turn = state.turn.copy();
        this.stack = state.stack.copy();
        this.command = state.command.copy();
        this.isPlaneChase = state.isPlaneChase;
        this.seenPlanes.addAll(state.seenPlanes);
        this.designations.addAll(state.designations);
        this.helperEmblems = CardUtil.deepCopyObject(state.helperEmblems);
        this.exile = state.exile.copy();
        this.battlefield = state.battlefield.copy();
        this.turnNum = state.turnNum;
        this.stepNum = state.stepNum;
        this.extraTurnId = state.extraTurnId;
        this.effects = state.effects.copy();
        this.triggered = CardUtil.deepCopyObject(state.triggered);
        this.triggers = state.triggers.copy();
        this.delayed = state.delayed.copy();
        this.specialActions = state.specialActions.copy();
        this.combat = state.combat.copy();
        this.turnMods = state.turnMods.copy();
        this.watchers = state.watchers.copy();
        this.values = CardUtil.deepCopyObject(state.values);
        this.zones.putAll(state.zones);
        this.simultaneousEvents.addAll(state.simultaneousEvents);
        this.cardState = CardUtil.deepCopyObject(state.cardState);
        this.permanentCostsTags = CardUtil.deepCopyObject(state.permanentCostsTags);
        this.mageObjectAttribute = CardUtil.deepCopyObject(state.mageObjectAttribute);
        this.zoneChangeCounter.putAll(state.zoneChangeCounter);
        this.copiedCards.putAll(state.copiedCards);
        this.permanentOrderNumber = state.permanentOrderNumber;
        this.applyEffectsCounter = state.applyEffectsCounter;
        state.usePowerInsteadOfToughnessForDamageLethalityFilters.forEach((uuid, filter) -> this.usePowerInsteadOfToughnessForDamageLethalityFilters.put((UUID)uuid, filter.copy()));
        this.commandersToStay.addAll(state.commandersToStay);
        this.hasDayNight = state.hasDayNight;
        this.isDaytime = state.isDaytime;
        this.reverseTurnOrder = state.reverseTurnOrder;
    }

    public void clearOnGameRestart() {
        this.battlefield.clear();
        this.effects.clear();
        this.triggers.clear();
        this.delayed.clear();
        this.triggered.clear();
        this.stack.clear();
        this.exile.clear();
        this.command.clear();
        this.designations.clear();
        this.helperEmblems.clear();
        this.seenPlanes.clear();
        this.isPlaneChase = false;
        this.revealed.clear();
        this.lookedAt.clear();
        this.companion.clear();
        this.turnNum = 1;
        this.stepNum = 0;
        this.extraTurnId = null;
        this.gameOver = false;
        this.specialActions.clear();
        this.cardState.clear();
        this.permanentCostsTags.clear();
        this.combat.clear();
        this.turnMods.clear();
        this.watchers.clear();
        this.values.clear();
        this.zones.clear();
        this.simultaneousEvents.clear();
        this.copiedCards.clear();
        this.usePowerInsteadOfToughnessForDamageLethalityFilters.clear();
        this.permanentOrderNumber = 0;
    }

    public void restoreForRollBack(GameState state) {
        this.restore(state);
        this.turn = state.turn;
    }

    public void restore(GameState state) {
        this.activePlayerId = state.activePlayerId;
        this.playerList.setCurrent(state.activePlayerId);
        this.playerByOrderId = state.playerByOrderId;
        this.priorityPlayerId = state.priorityPlayerId;
        this.monarchId = state.monarchId;
        this.initiativeId = state.initiativeId;
        this.stack = state.stack;
        this.command = state.command;
        this.isPlaneChase = state.isPlaneChase;
        this.seenPlanes = state.seenPlanes;
        this.designations = state.designations;
        this.helperEmblems = state.helperEmblems;
        this.exile = state.exile;
        this.battlefield = state.battlefield;
        this.turnNum = state.turnNum;
        this.stepNum = state.stepNum;
        this.extraTurnId = state.extraTurnId;
        this.effects = state.effects;
        this.triggered = state.triggered;
        this.triggers = state.triggers;
        this.delayed = state.delayed;
        this.specialActions = state.specialActions;
        this.combat = state.combat;
        this.turnMods = state.turnMods;
        this.watchers = state.watchers;
        this.values = state.values;
        for (Player copyPlayer : state.players.values()) {
            Player origPlayer = (Player)this.players.get(copyPlayer.getId());
            origPlayer.restore(copyPlayer);
        }
        this.zones = state.zones;
        this.simultaneousEvents = state.simultaneousEvents;
        this.cardState = state.cardState;
        this.permanentCostsTags = state.permanentCostsTags;
        this.mageObjectAttribute = state.mageObjectAttribute;
        this.zoneChangeCounter = state.zoneChangeCounter;
        this.copiedCards = state.copiedCards;
        this.permanentOrderNumber = state.permanentOrderNumber;
        this.applyEffectsCounter = state.applyEffectsCounter;
        state.usePowerInsteadOfToughnessForDamageLethalityFilters.forEach((uuid, filter) -> this.usePowerInsteadOfToughnessForDamageLethalityFilters.put((UUID)uuid, filter.copy()));
        this.commandersToStay = state.commandersToStay;
        this.hasDayNight = state.hasDayNight;
        this.isDaytime = state.isDaytime;
        this.reverseTurnOrder = state.reverseTurnOrder;
    }

    @Override
    public GameState copy() {
        return new GameState(this);
    }

    public void addPlayer(Player player) {
        this.players.put(player.getId(), player);
        this.playerList.add(player.getId());
    }

    public String getValue(boolean useHidden) {
        StringBuilder sb = threadLocalBuilder.get();
        sb.append(this.turn.getValue(this.turnNum));
        sb.append(this.activePlayerId).append(this.priorityPlayerId).append(this.playerByOrderId);
        for (Player player : this.players.values()) {
            sb.append("player").append(player.getLife()).append("hand");
            if (useHidden) {
                sb.append(player.getHand());
            } else {
                sb.append(player.getHand().size());
            }
            sb.append("library").append(player.getLibrary().size()).append("graveyard").append(player.getGraveyard());
        }
        sb.append("permanents");
        for (Permanent permanent : this.battlefield.getAllPermanents()) {
            sb.append(permanent.getValue(this));
        }
        sb.append("spells");
        for (StackObject spell : this.stack) {
            sb.append(spell.getControllerId()).append(spell.getName());
        }
        for (ExileZone zone : this.exile.getExileZones()) {
            sb.append("exile").append(zone.getName()).append(zone);
        }
        sb.append("combat");
        for (CombatGroup group : this.combat.getGroups()) {
            sb.append(group.getDefenderId()).append(group.getAttackers()).append(group.getBlockers());
        }
        return sb.toString();
    }

    public String getValue(boolean useHidden, Game game) {
        StringBuilder sb = threadLocalBuilder.get();
        sb.append(this.turn.getValue(this.turnNum));
        sb.append(this.activePlayerId).append(this.priorityPlayerId).append(this.playerByOrderId);
        for (Player player : this.players.values()) {
            sb.append("player").append(player.isPassed()).append(player.getLife()).append("hand");
            if (useHidden) {
                sb.append(player.getHand().getValue(game));
            } else {
                sb.append(player.getHand().size());
            }
            sb.append("library").append(player.getLibrary().size());
            sb.append("graveyard");
            sb.append(player.getGraveyard().getValue(game));
        }
        sb.append("permanents");
        ArrayList<String> perms = new ArrayList<String>();
        for (Permanent permanent : this.battlefield.getAllPermanents()) {
            perms.add(permanent.getValue(this));
        }
        Collections.sort(perms);
        sb.append(perms);
        sb.append("spells");
        for (StackObject spell : this.stack) {
            sb.append(spell.getControllerId()).append(spell.getName());
            sb.append(spell.getStackAbility().toString());
            for (UUID modeId : spell.getStackAbility().getModes().getSelectedModes()) {
                Mode mode = spell.getStackAbility().getModes().get(modeId);
                if (mode.getTargets().isEmpty()) continue;
                sb.append("targets");
                for (Target target : mode.getTargets()) {
                    sb.append(target.getTargets());
                }
            }
        }
        for (ExileZone zone : this.exile.getExileZones()) {
            sb.append("exile").append(zone.getName()).append(zone.getValue(game));
        }
        sb.append("combat");
        for (CombatGroup group : this.combat.getGroups()) {
            sb.append(group.getDefenderId()).append(group.getAttackers()).append(group.getBlockers());
        }
        return sb.toString();
    }

    public String getValue(Game game, UUID playerId) {
        StringBuilder sb = threadLocalBuilder.get();
        sb.append(this.turn.getValue(this.turnNum));
        sb.append(this.activePlayerId).append(this.priorityPlayerId).append(this.playerByOrderId);
        for (Player player : this.players.values()) {
            sb.append("player").append(player.isPassed()).append(player.getLife()).append("hand");
            if (Objects.equals(playerId, player.getId())) {
                sb.append(player.getHand().getValue(game));
            } else {
                sb.append(player.getHand().size());
            }
            sb.append("library").append(player.getLibrary().size());
            sb.append("graveyard");
            sb.append(player.getGraveyard().getValue(game));
        }
        sb.append("permanents");
        ArrayList<String> perms = new ArrayList<String>();
        for (Permanent permanent : this.battlefield.getAllPermanents()) {
            perms.add(permanent.getValue(this));
        }
        Collections.sort(perms);
        sb.append(perms);
        sb.append("spells");
        for (StackObject spell : this.stack) {
            sb.append(spell.getControllerId()).append(spell.getName());
            sb.append(spell.getStackAbility().toString());
            for (UUID modeId : spell.getStackAbility().getModes().getSelectedModes()) {
                Mode mode = spell.getStackAbility().getModes().get(modeId);
                if (mode.getTargets().isEmpty()) continue;
                sb.append("targets");
                for (Target target : mode.getTargets()) {
                    sb.append(target.getTargets());
                }
            }
        }
        for (ExileZone zone : this.exile.getExileZones()) {
            sb.append("exile").append(zone.getName()).append(zone.getValue(game));
        }
        sb.append("combat");
        for (CombatGroup group : this.combat.getGroups()) {
            sb.append(group.getDefenderId()).append(group.getAttackers()).append(group.getBlockers());
        }
        return sb.toString();
    }

    public Players getPlayers() {
        return this.players;
    }

    public Player getPlayer(UUID playerId) {
        return (Player)this.players.get(playerId);
    }

    public UUID getActivePlayerId() {
        return this.activePlayerId;
    }

    public void setActivePlayerId(UUID activePlayerId) {
        this.activePlayerId = activePlayerId;
    }

    public UUID getPlayerByOrderId() {
        return this.playerByOrderId;
    }

    public void setPlayerByOrderId(UUID playerByOrderId) {
        this.playerByOrderId = playerByOrderId;
    }

    public UUID getPriorityPlayerId() {
        return this.priorityPlayerId;
    }

    public void setPriorityPlayerId(UUID priorityPlayerId) {
        this.priorityPlayerId = priorityPlayerId;
    }

    public UUID getMonarchId() {
        return this.monarchId;
    }

    public void setMonarchId(UUID monarchId) {
        this.monarchId = monarchId;
    }

    public UUID getInitiativeId() {
        return this.initiativeId;
    }

    public void setInitiativeId(UUID initiativeId) {
        this.initiativeId = initiativeId;
    }

    public UUID getChoosingPlayerId() {
        return this.choosingPlayerId;
    }

    public void setChoosingPlayerId(UUID choosingPlayerId) {
        this.choosingPlayerId = choosingPlayerId;
    }

    public Battlefield getBattlefield() {
        return this.battlefield;
    }

    public SpellStack getStack() {
        return this.stack;
    }

    public Exile getExile() {
        return this.exile;
    }

    public List<Designation> getDesignations() {
        return this.designations;
    }

    public List<Emblem> getHelperEmblems() {
        return this.helperEmblems;
    }

    public Plane getCurrentPlane() {
        if (this.command != null && !this.command.isEmpty()) {
            for (CommandObject cobject : this.command) {
                if (!(cobject instanceof Plane)) continue;
                return (Plane)cobject;
            }
        }
        return null;
    }

    public List<String> getSeenPlanes() {
        return this.seenPlanes;
    }

    public boolean isPlaneChase() {
        return this.isPlaneChase;
    }

    public Command getCommand() {
        return this.command;
    }

    public Revealed getRevealed() {
        return this.revealed;
    }

    public LookedAt getLookedAt(UUID playerId) {
        if (this.lookedAt.get(playerId) == null) {
            LookedAt lookedAtCards = new LookedAt();
            this.lookedAt.put(playerId, lookedAtCards);
            return lookedAtCards;
        }
        return this.lookedAt.get(playerId);
    }

    public Revealed getCompanion() {
        return this.companion;
    }

    public void clearRevealed() {
        this.revealed.clear();
    }

    public void clearLookedAt() {
        this.lookedAt.clear();
    }

    public void clearCompanion() {
        this.companion.clear();
    }

    public Turn getTurn() {
        return this.turn;
    }

    public PhaseStep getTurnStepType() {
        Turn turn = this.getTurn();
        Phase phase = turn != null ? turn.getPhase() : null;
        Step step = phase != null ? phase.getStep() : null;
        return step != null ? step.getType() : null;
    }

    public TurnPhase getTurnPhaseType() {
        Turn turn = this.getTurn();
        Phase phase = turn != null ? turn.getPhase() : null;
        return phase != null ? phase.getType() : null;
    }

    public Combat getCombat() {
        return this.combat;
    }

    public int getStepNum() {
        return this.stepNum;
    }

    public void increaseStepNum() {
        ++this.stepNum;
    }

    public int getTurnNum() {
        return this.turnNum;
    }

    public void setTurnNum(int turnNum) {
        this.turnNum = turnNum;
    }

    public UUID getExtraTurnId() {
        return this.extraTurnId;
    }

    public void setExtraTurnId(UUID extraTurnId) {
        this.extraTurnId = extraTurnId;
    }

    public boolean isExtraTurn() {
        return this.extraTurnId != null;
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public TurnMods getTurnMods() {
        return this.turnMods;
    }

    public <T extends Watcher> T getWatcher(Class<T> watcherClass) {
        return this.getWatcher(watcherClass, null);
    }

    public <T extends Watcher> T getWatcher(Class<T> watcherClass, UUID uuid) {
        String watcherKey = (uuid == null ? "" : uuid.toString()) + watcherClass.getSimpleName();
        return (T)((Watcher)watcherClass.cast(this.getWatcher(watcherKey)));
    }

    public Watcher getWatcher(String key) {
        return this.watchers.get(key);
    }

    public SpecialActions getSpecialActions() {
        return this.specialActions;
    }

    public void endGame() {
        this.gameOver = true;
    }

    void applyEffects(Game game) {
        ++this.applyEffectsCounter;
        for (Player player : this.players.values()) {
            player.reset();
        }
        this.battlefield.reset(game);
        this.combat.reset(game);
        this.reset();
        this.effects.apply(game);
        this.combat.checkForRemoveFromCombat(game);
    }

    public void removeEocEffects(Game game) {
        this.effects.removeEndOfCombatEffects();
        this.delayed.removeEndOfCombatAbilities();
        game.applyEffects();
    }

    public void removeEotEffects(Game game) {
        this.effects.removeEndOfTurnEffects(game);
        this.delayed.removeEndOfTurnAbilities(game);
        this.exile.cleanupEndOfTurnZones(game);
        game.applyEffects();
    }

    public void removeBoESEffects(Game game) {
        this.effects.removeBeginningOfEndStepEffects(game);
    }

    public void removeTurnStartEffect(Game game) {
        this.delayed.removeStartOfNewTurn(game);
    }

    public void addEffect(ContinuousEffect effect, Ability source) {
        this.addEffect(effect, null, source);
    }

    public void addEffect(ContinuousEffect effect, UUID sourceId, Ability source) {
        if (sourceId == null) {
            this.effects.addEffect(effect, source);
        } else {
            this.effects.addEffect(effect, sourceId, source);
        }
    }

    private void addTrigger(TriggeredAbility ability, UUID sourceId, MageObject attachedTo) {
        if (sourceId == null) {
            this.triggers.add(ability, attachedTo);
        } else {
            this.triggers.add(ability, sourceId, attachedTo);
        }
    }

    public PlayerList getPlayerList() {
        return this.playerList;
    }

    public PlayerList getPlayerList(UUID playerId) {
        PlayerList newPlayerList = new PlayerList();
        for (Player player : this.players.values()) {
            if (!player.isInGame()) continue;
            newPlayerList.add(player.getId());
        }
        newPlayerList.setCurrent(playerId);
        return newPlayerList;
    }

    public PlayerList getPlayersInRange(UUID playerId, Game game) {
        return this.getPlayersInRange(playerId, game, false);
    }

    public PlayerList getPlayersInRange(UUID playerId, Game game, boolean excludeLeavedPlayers) {
        PlayerList newPlayerList = new PlayerList();
        Player currentPlayer = game.getPlayer(playerId);
        if (currentPlayer != null) {
            for (Player player : this.players.values()) {
                if (excludeLeavedPlayers && !player.isInGame() || !currentPlayer.hasPlayerInRange(player.getId())) continue;
                newPlayerList.add(player.getId());
            }
            newPlayerList.setCurrent(playerId);
        }
        return newPlayerList;
    }

    public Permanent getPermanent(UUID permanentId) {
        if (permanentId != null && this.battlefield.containsPermanent(permanentId)) {
            return this.battlefield.getPermanent(permanentId);
        }
        return null;
    }

    public Zone getZone(UUID id) {
        if (id != null && this.zones.containsKey(id)) {
            return this.zones.get(id);
        }
        return null;
    }

    public void setZone(UUID id, Zone zone) {
        if (zone == null) {
            this.zones.remove(id);
        } else {
            this.zones.put(id, zone);
        }
    }

    public void addSimultaneousEvent(GameEvent event, Game game) {
        this.simultaneousEvents.add(event);
    }

    public void handleSimultaneousEvent(Game game) {
        if (!this.simultaneousEvents.isEmpty() && !this.getTurn().isEndTurnRequested()) {
            ArrayList<GameEvent> eventsToHandle = new ArrayList<GameEvent>();
            List<GameEvent> eventGroups = this.createEventGroups(this.simultaneousEvents, game);
            eventsToHandle.addAll(this.simultaneousEvents);
            eventsToHandle.addAll(eventGroups);
            this.simultaneousEvents.clear();
            for (GameEvent event : eventsToHandle) {
                this.handleEvent(event, game);
            }
        }
    }

    public boolean hasSimultaneousEvents() {
        return !this.simultaneousEvents.isEmpty();
    }

    public void addBatchDamageCouldHaveBeenFired(boolean combat, Game game) {
        for (GameEvent event : this.simultaneousEvents) {
            if (!(event instanceof DamagedBatchCouldHaveFiredEvent) || ((DamagedBatchCouldHaveFiredEvent)event).isCombat() != combat) continue;
            return;
        }
        this.addSimultaneousEvent(new DamagedBatchCouldHaveFiredEvent(combat), game);
    }

    public void addSimultaneousDamage(DamagedEvent damagedEvent, Game game) {
        if (damagedEvent instanceof DamagedPlayerEvent) {
            this.addSimultaneousDamageToPlayerBatches((DamagedPlayerEvent)damagedEvent, game);
        } else if (damagedEvent instanceof DamagedPermanentEvent) {
            this.addSimultaneousDamageToPermanentBatches((DamagedPermanentEvent)damagedEvent, game);
        }
        this.addSimultaneousDamageBySourceBatched(damagedEvent, game);
        this.addSimultaneousDamageToBatchForAll(damagedEvent, game);
    }

    public void addSimultaneousDamageToPlayerBatches(DamagedPlayerEvent damagedPlayerEvent, Game game) {
        boolean isTotalBatchUsed = false;
        boolean isPlayerBatchUsed = false;
        for (GameEvent event : this.simultaneousEvents) {
            if (event instanceof DamagedBatchForPlayersEvent) {
                ((DamagedBatchForPlayersEvent)event).addEvent(damagedPlayerEvent);
                isTotalBatchUsed = true;
                continue;
            }
            if (!(event instanceof DamagedBatchForOnePlayerEvent) || !damagedPlayerEvent.getTargetId().equals(event.getTargetId())) continue;
            ((DamagedBatchForOnePlayerEvent)event).addEvent(damagedPlayerEvent);
            isPlayerBatchUsed = true;
        }
        if (!isTotalBatchUsed) {
            this.addSimultaneousEvent(new DamagedBatchForPlayersEvent(damagedPlayerEvent), game);
        }
        if (!isPlayerBatchUsed) {
            this.addSimultaneousEvent(new DamagedBatchForOnePlayerEvent(damagedPlayerEvent), game);
        }
    }

    public void addSimultaneousDamageToPermanentBatches(DamagedPermanentEvent damagedPermanentEvent, Game game) {
        boolean isTotalBatchUsed = false;
        boolean isSingleBatchUsed = false;
        for (GameEvent event : this.simultaneousEvents) {
            if (event instanceof DamagedBatchForPermanentsEvent) {
                ((DamagedBatchForPermanentsEvent)event).addEvent(damagedPermanentEvent);
                isTotalBatchUsed = true;
                continue;
            }
            if (!(event instanceof DamagedBatchForOnePermanentEvent) || !damagedPermanentEvent.getTargetId().equals(event.getTargetId())) continue;
            ((DamagedBatchForOnePermanentEvent)event).addEvent(damagedPermanentEvent);
            isSingleBatchUsed = true;
        }
        if (!isTotalBatchUsed) {
            this.addSimultaneousEvent(new DamagedBatchForPermanentsEvent(damagedPermanentEvent), game);
        }
        if (!isSingleBatchUsed) {
            this.addSimultaneousEvent(new DamagedBatchForOnePermanentEvent(damagedPermanentEvent), game);
        }
    }

    public void addSimultaneousDamageBySourceBatched(DamagedEvent damageEvent, Game game) {
        boolean isBatchUsed = false;
        for (GameEvent event : this.simultaneousEvents) {
            if (!(event instanceof DamagedBatchBySourceEvent) || !damageEvent.getSourceId().equals(event.getSourceId())) continue;
            ((DamagedBatchBySourceEvent)event).addEvent(damageEvent);
            isBatchUsed = true;
        }
        if (!isBatchUsed) {
            this.addSimultaneousEvent(new DamagedBatchBySourceEvent(damageEvent), game);
        }
    }

    public void addSimultaneousDamageToBatchForAll(DamagedEvent damagedEvent, Game game) {
        boolean isBatchUsed = false;
        for (GameEvent event : this.simultaneousEvents) {
            if (!(event instanceof DamagedBatchAllEvent)) continue;
            ((DamagedBatchAllEvent)event).addEvent(damagedEvent);
            isBatchUsed = true;
        }
        if (!isBatchUsed) {
            this.addSimultaneousEvent(new DamagedBatchAllEvent(damagedEvent), game);
        }
    }

    public void addSimultaneousMilledCardToBatch(MilledCardEvent milledEvent, Game game) {
        boolean isBatchUsed = false;
        boolean isBatchForPlayerUsed = false;
        for (GameEvent event : this.simultaneousEvents) {
            if (event instanceof MilledBatchAllEvent) {
                ((MilledBatchAllEvent)event).addEvent(milledEvent);
                isBatchUsed = true;
                continue;
            }
            if (!(event instanceof MilledBatchForOnePlayerEvent) || !event.getPlayerId().equals(milledEvent.getPlayerId())) continue;
            ((MilledBatchForOnePlayerEvent)event).addEvent(milledEvent);
            isBatchForPlayerUsed = true;
        }
        if (!isBatchUsed) {
            this.addSimultaneousEvent(new MilledBatchAllEvent(milledEvent), game);
        }
        if (!isBatchForPlayerUsed) {
            this.addSimultaneousEvent(new MilledBatchForOnePlayerEvent(milledEvent), game);
        }
    }

    public void addSimultaneousSacrificedPermanentToBatch(SacrificedPermanentEvent sacrificedPermanentEvent, Game game) {
        boolean isBatchUsed = false;
        for (GameEvent event : this.simultaneousEvents) {
            if (!(event instanceof SacrificedPermanentBatchEvent)) continue;
            ((SacrificedPermanentBatchEvent)event).addEvent(sacrificedPermanentEvent);
            isBatchUsed = true;
        }
        if (!isBatchUsed) {
            this.addSimultaneousEvent(new SacrificedPermanentBatchEvent(sacrificedPermanentEvent), game);
        }
    }

    public void addSimultaneousLifeLossToBatch(LifeLostEvent lifeLossEvent, Game game) {
        boolean isLifeLostBatchUsed = false;
        boolean isSingleBatchUsed = false;
        for (GameEvent event : this.simultaneousEvents) {
            if (event instanceof LifeLostBatchEvent) {
                ((LifeLostBatchEvent)event).addEvent(lifeLossEvent);
                isLifeLostBatchUsed = true;
                continue;
            }
            if (!(event instanceof LifeLostBatchForOnePlayerEvent) || !event.getTargetId().equals(lifeLossEvent.getTargetId())) continue;
            ((LifeLostBatchForOnePlayerEvent)event).addEvent(lifeLossEvent);
            isSingleBatchUsed = true;
        }
        if (!isLifeLostBatchUsed) {
            this.addSimultaneousEvent(new LifeLostBatchEvent(lifeLossEvent), game);
        }
        if (!isSingleBatchUsed) {
            this.addSimultaneousEvent(new LifeLostBatchForOnePlayerEvent(lifeLossEvent), game);
        }
    }

    public void addSimultaneousTappedToBatch(TappedEvent tappedEvent, Game game) {
        boolean isTappedBatchUsed = false;
        for (GameEvent event : this.simultaneousEvents) {
            if (!(event instanceof TappedBatchEvent)) continue;
            ((TappedBatchEvent)event).addEvent(tappedEvent);
            isTappedBatchUsed = true;
            break;
        }
        if (!isTappedBatchUsed) {
            this.addSimultaneousEvent(new TappedBatchEvent(tappedEvent), game);
        }
    }

    public void addSimultaneousUntappedToBatch(UntappedEvent untappedEvent, Game game) {
        boolean isUntappedBatchUsed = false;
        for (GameEvent event : this.simultaneousEvents) {
            if (!(event instanceof UntappedBatchEvent)) continue;
            ((UntappedBatchEvent)event).addEvent(untappedEvent);
            isUntappedBatchUsed = true;
            break;
        }
        if (!isUntappedBatchUsed) {
            this.addSimultaneousEvent(new UntappedBatchEvent(untappedEvent), game);
        }
    }

    public void handleEvent(GameEvent event, Game game) {
        this.watchers.watch(event, game);
        this.delayed.checkTriggers(event, game);
        this.triggers.checkTriggers(event, game);
    }

    public boolean replaceEvent(GameEvent event, Game game) {
        return this.replaceEvent(event, null, game);
    }

    public boolean replaceEvent(GameEvent event, Ability targetAbility, Game game) {
        if (this.effects.preventedByRuleModification(event, targetAbility, game, false)) {
            return true;
        }
        return this.effects.replaceEvent(event, game);
    }

    public List<GameEvent> createEventGroups(List<GameEvent> events, Game game) {
        class ZoneChangeData {
            private final Zone fromZone;
            private final Zone toZone;
            private final UUID sourceId;
            private final UUID playerId;
            Ability source;

            public ZoneChangeData(Ability source, UUID sourceId, UUID playerId, Zone fromZone, Zone toZone) {
                this.sourceId = sourceId;
                this.playerId = playerId;
                this.fromZone = fromZone;
                this.toZone = toZone;
                this.source = source;
            }

            public int hashCode() {
                return (this.fromZone.ordinal() + 1) * 1 + (this.toZone.ordinal() + 1) * 10 + (this.sourceId != null ? this.sourceId.hashCode() : 0) + (this.source != null ? this.source.hashCode() : 0);
            }

            public boolean equals(Object obj) {
                if (obj instanceof ZoneChangeData) {
                    ZoneChangeData data = (ZoneChangeData)obj;
                    return this.fromZone == data.fromZone && this.toZone == data.toZone && Objects.equals(this.sourceId, data.sourceId) && Objects.equals(this.source, data.source);
                }
                return false;
            }
        }
        HashMap eventsByKey = new HashMap();
        LinkedList<GameEvent> groupEvents = new LinkedList<GameEvent>();
        ZoneChangeBatchEvent batchEvent = new ZoneChangeBatchEvent();
        for (GameEvent gameEvent : events) {
            if (!(gameEvent instanceof ZoneChangeEvent)) continue;
            ZoneChangeEvent castEvent = (ZoneChangeEvent)gameEvent;
            batchEvent.addEvent(castEvent);
            ZoneChangeData key = new ZoneChangeData(castEvent.getSource(), castEvent.getSourceId(), castEvent.getPlayerId(), castEvent.getFromZone(), castEvent.getToZone());
            if (eventsByKey.containsKey(key)) {
                ((List)eventsByKey.get(key)).add(gameEvent);
                continue;
            }
            LinkedList<GameEvent> list = new LinkedList<GameEvent>();
            list.add(gameEvent);
            eventsByKey.put(key, list);
        }
        for (Map.Entry entry : eventsByKey.entrySet()) {
            LinkedHashSet<Card> movedCards = new LinkedHashSet<Card>();
            LinkedHashSet<PermanentToken> movedTokens = new LinkedHashSet<PermanentToken>();
            for (GameEvent event2 : (List)entry.getValue()) {
                ZoneChangeEvent castEvent = (ZoneChangeEvent)event2;
                UUID targetId = castEvent.getTargetId();
                Card card = ZonesHandler.getTargetCard(game, targetId);
                if (card instanceof PermanentToken) {
                    movedTokens.add((PermanentToken)card);
                    continue;
                }
                if (game.getObject(targetId) instanceof PermanentToken) {
                    movedTokens.add((PermanentToken)game.getObject(targetId));
                    continue;
                }
                if (card == null) continue;
                movedCards.add(card);
            }
            ZoneChangeData eventData = (ZoneChangeData)entry.getKey();
            if (movedCards.isEmpty() && movedTokens.isEmpty()) continue;
            ZoneChangeGroupEvent event = new ZoneChangeGroupEvent(movedCards, movedTokens, eventData.sourceId, eventData.source, eventData.playerId, eventData.fromZone, eventData.toZone);
            groupEvents.add(event);
        }
        if (!batchEvent.getEvents().isEmpty()) {
            groupEvents.add(batchEvent);
        }
        return groupEvents;
    }

    public void addCard(Card card) {
        this.addCard(card, Zone.OUTSIDE);
    }

    private void addCard(Card card, Zone zone) {
        this.setZone(card.getId(), zone);
        for (Ability ability : card.getInitAbilities()) {
            this.addAbility(ability, null, card);
        }
    }

    public void addAbility(Ability ability, Card attachedTo) {
        this.addAbility(ability, null, attachedTo);
    }

    public void addAbility(Ability ability, MageObject attachedTo) {
        if (ability instanceof StaticAbility) {
            for (UUID modeId : ability.getModes().getSelectedModes()) {
                Mode mode = ability.getModes().get(modeId);
                for (Effect effect : mode.getEffects()) {
                    if (!(effect instanceof ContinuousEffect)) continue;
                    this.addEffect((ContinuousEffect)effect, ability);
                }
            }
        } else if (ability instanceof TriggeredAbility) {
            this.addTrigger((TriggeredAbility)ability, null, attachedTo);
        }
    }

    public void addAbility(Ability ability, UUID sourceId, MageObject attachedTo) {
        if (ability instanceof StaticAbility) {
            for (UUID modeId : ability.getModes().getSelectedModes()) {
                Mode mode = ability.getModes().get(modeId);
                for (Effect effect : mode.getEffects()) {
                    if (!(effect instanceof ContinuousEffect)) continue;
                    this.addEffect((ContinuousEffect)effect, sourceId, ability);
                }
            }
        } else if (ability instanceof TriggeredAbility) {
            this.addTrigger((TriggeredAbility)ability, sourceId, attachedTo);
        }
        for (Watcher watcher : ability.getWatchers()) {
            UUID controllerId = ability.getControllerId();
            if (attachedTo instanceof Card) {
                controllerId = ((Card)attachedTo).getOwnerId();
            } else if (attachedTo instanceof Controllable) {
                controllerId = ((Controllable)((Object)attachedTo)).getControllerId();
            }
            Object newWatcher = watcher.copy();
            ((Watcher)newWatcher).setControllerId(controllerId);
            ((Watcher)newWatcher).setSourceId(attachedTo == null ? ability.getSourceId() : attachedTo.getId());
            this.watchers.add((Watcher)newWatcher);
        }
        for (Ability sub : ability.getSubAbilities()) {
            this.addAbility(sub, sourceId, attachedTo);
        }
    }

    public void addHelperEmblem(Emblem emblem, UUID controllerId) {
        this.helperEmblems.add(emblem);
        emblem.setControllerId(controllerId);
        for (Ability ability : emblem.getInitAbilities()) {
            ability.setControllerId(controllerId);
            ability.setSourceId(emblem.getId());
            this.addAbility(ability, null, emblem);
        }
    }

    public void addDesignation(Designation designation, Game game, UUID controllerId) {
        this.getDesignations().add(designation);
        for (Ability ability : designation.getInitAbilities()) {
            ability.setControllerId(controllerId);
            this.addAbility(ability, designation.getId(), null);
        }
    }

    public void addSeenPlane(Plane plane, Game game, UUID controllerId) {
        if (plane != null) {
            this.getSeenPlanes().add(plane.getName());
        }
    }

    public void resetSeenPlanes() {
        this.getSeenPlanes().clear();
    }

    public void setPlaneChase(Game game, boolean isPlaneChase) {
        this.isPlaneChase = isPlaneChase;
    }

    public void addCommandObject(CommandObject commandObject) {
        this.getCommand().add(commandObject);
        this.setZone(commandObject.getId(), Zone.COMMAND);
        for (Ability ability : commandObject.getInitAbilities()) {
            this.addAbility(ability, commandObject);
        }
    }

    public void clearTriggeredAbilities() {
        this.triggered.clear();
    }

    public void addTriggeredAbility(TriggeredAbility ability) {
        this.triggered.add(ability);
    }

    public void removeTriggeredAbility(TriggeredAbility ability) {
        this.triggered.remove(ability);
    }

    public void addDelayedTriggeredAbility(DelayedTriggeredAbility ability) {
        this.delayed.add(ability);
        ArrayList<Watcher> watcherList = new ArrayList<Watcher>(ability.getWatchers());
        for (Watcher watcher : watcherList) {
            Object newWatcher = watcher.copy();
            ((Watcher)newWatcher).setControllerId(ability.getControllerId());
            ((Watcher)newWatcher).setSourceId(ability.getSourceId());
            this.watchers.add((Watcher)newWatcher);
        }
    }

    public void removeDelayedTriggeredAbility(UUID abilityId) {
        this.delayed.removeIf(ability -> ability.getId().equals(abilityId));
    }

    public List<TriggeredAbility> getTriggered(UUID controllerId) {
        return this.triggered.stream().filter(triggeredAbility -> controllerId.equals(triggeredAbility.getControllerId())).collect(Collectors.toList());
    }

    public DelayedTriggeredAbilities getDelayed() {
        return this.delayed;
    }

    public ContinuousEffects getContinuousEffects() {
        return this.effects;
    }

    public Object getValue(String valueId) {
        return this.values.get(valueId);
    }

    public Object computeValueIfAbsent(String valueId, Function<String, ?> mappingFunction) {
        return this.values.computeIfAbsent(valueId, mappingFunction);
    }

    public Map<String, Object> getValues(String startWithValue) {
        if (startWithValue == null || startWithValue.isEmpty()) {
            throw new IllegalArgumentException("Can't use empty search value");
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            if (!entry.getKey().startsWith(startWithValue)) continue;
            res.put(entry.getKey(), entry.getValue());
        }
        return res;
    }

    public <T> T setValue(String valueId, T value) {
        this.values.put(valueId, value);
        return value;
    }

    public void removeValue(String valueId) {
        this.values.remove(valueId);
    }

    public Abilities<ActivatedAbility> getActivatedOtherAbilities(UUID objectId, Zone zone) {
        if (this.cardState.containsKey(objectId)) {
            return this.cardState.get(objectId).getAbilities().getActivatedAbilities(zone);
        }
        return null;
    }

    public Abilities<Ability> getAllOtherAbilities(UUID objectId) {
        if (this.cardState.containsKey(objectId)) {
            return this.cardState.get(objectId).getAbilities();
        }
        return null;
    }

    public void addOtherAbility(Card attachedTo, Ability ability) {
        this.addOtherAbility(attachedTo, ability, true);
    }

    public void addOtherAbility(Card attachedTo, Ability ability, boolean copyAbility) {
        Ability newAbility;
        this.checkWrongDynamicAbilityUsage(attachedTo, ability);
        if (ability instanceof MageSingleton || !copyAbility) {
            if (attachedTo.getAbilities().contains(ability) || this.getAllOtherAbilities(attachedTo.getId()) != null && this.getAllOtherAbilities(attachedTo.getId()).contains(ability)) {
                return;
            }
            newAbility = ability;
        } else {
            newAbility = ability.copy();
            newAbility.newId();
        }
        newAbility.setSourceId(attachedTo.getId());
        newAbility.setControllerId(attachedTo.getOwnerId());
        if (!this.cardState.containsKey(attachedTo.getId())) {
            this.cardState.put(attachedTo.getId(), new CardState());
        }
        this.cardState.get(attachedTo.getId()).addAbility(newAbility);
        this.addAbility(newAbility, attachedTo.getId(), attachedTo);
    }

    private void checkWrongDynamicAbilityUsage(Card attachedTo, Ability ability) {
        if (attachedTo instanceof PermanentCard) {
            throw new IllegalArgumentException("Error, wrong code usage. If you want to add new ability to the permanent then use a permanent.addAbility(a, source, game): " + ability.getClass().getCanonicalName() + " - " + ability);
        }
    }

    public void removeTriggersOfSourceId(UUID sourceId) {
        this.triggers.removeAbilitiesOfSource(sourceId);
    }

    private void reset() {
        this.triggers.removeAllGainedAbilities();
        this.getContinuousEffects().removeAllTemporaryEffects();
        for (CardState state : this.cardState.values()) {
            state.clearAbilities();
        }
        this.mageObjectAttribute.clear();
        this.setManaBurn(false);
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public TriggeredAbilities getTriggers() {
        return this.triggers;
    }

    public CardState getCardState(UUID cardId) {
        this.cardState.putIfAbsent(cardId, new CardState());
        return this.cardState.get(cardId);
    }

    public MageObjectAttribute getMageObjectAttribute(UUID cardId) {
        return this.mageObjectAttribute.get(cardId);
    }

    public MageObjectAttribute getCreateMageObjectAttribute(MageObject mageObject, Game game) {
        MageObjectAttribute mageObjectAtt = this.mageObjectAttribute.computeIfAbsent(mageObject.getId(), k -> new MageObjectAttribute(mageObject, game));
        return mageObjectAtt;
    }

    public Map<MageObjectReference, Map<String, Object>> getPermanentCostsTags() {
        return this.permanentCostsTags;
    }

    void storePermanentCostsTags(MageObjectReference permanentMOR, Ability source) {
        if (source.getCostsTagMap() != null) {
            this.permanentCostsTags.put(permanentMOR, CardUtil.deepCopyObject(source.getCostsTagMap()));
        }
    }

    public void cleanupPermanentCostsTags(Game game) {
        this.getPermanentCostsTags().entrySet().removeIf(entry -> ((MageObjectReference)entry.getKey()).getZoneChangeCounter() != game.getState().getZoneChangeCounter(((MageObjectReference)entry.getKey()).getSourceId()) - 1);
    }

    public void addWatcher(Watcher newWatcher) {
        this.watchers.add(newWatcher);
    }

    public void resetWatchers() {
        this.watchers.reset();
    }

    public int getZoneChangeCounter(UUID objectId) {
        return this.zoneChangeCounter.getOrDefault(objectId, 1);
    }

    public void updateZoneChangeCounter(UUID objectId) {
        int value = this.getZoneChangeCounter(objectId);
        this.setZoneChangeCounter(objectId, ++value);
        if (this.cardState.containsKey(objectId)) {
            this.cardState.get(objectId).clear();
        }
    }

    public void setZoneChangeCounter(UUID objectId, int value) {
        this.zoneChangeCounter.put(objectId, value);
    }

    public Card getCopiedCard(UUID cardId) {
        return this.copiedCards.get(cardId);
    }

    public Collection<Card> getCopiedCards() {
        return this.copiedCards.values();
    }

    public Card copyCard(Card mainCardToCopy, UUID newController, Game game) {
        SubCard<SplitCard> leftOriginal;
        if (!mainCardToCopy.getId().equals(mainCardToCopy.getMainCard().getId())) {
            throw new IllegalArgumentException("Wrong code usage. You can copy only main card.");
        }
        ArrayList<Card> copiedParts = new ArrayList<Card>();
        Card copiedCard = mainCardToCopy.copy();
        copiedParts.add(copiedCard);
        if (copiedCard instanceof SplitCard) {
            leftOriginal = ((SplitCard)copiedCard).getLeftHalfCard();
            SplitCardHalf leftCopied = leftOriginal.copy();
            this.prepareCardForCopy(leftOriginal, leftCopied, newController);
            copiedParts.add(leftCopied);
            SplitCardHalf rightOriginal = ((SplitCard)copiedCard).getRightHalfCard();
            SplitCardHalf rightCopied = rightOriginal.copy();
            this.prepareCardForCopy(rightOriginal, rightCopied, newController);
            copiedParts.add(rightCopied);
            ((SplitCard)copiedCard).setParts(leftCopied, rightCopied);
        } else if (copiedCard instanceof ModalDoubleFacedCard) {
            leftOriginal = ((ModalDoubleFacedCard)copiedCard).getLeftHalfCard();
            ModalDoubleFacedCardHalf leftCopied = leftOriginal.copy();
            this.prepareCardForCopy(leftOriginal, leftCopied, newController);
            copiedParts.add(leftCopied);
            ModalDoubleFacedCardHalf rightOriginal = ((ModalDoubleFacedCard)copiedCard).getRightHalfCard();
            ModalDoubleFacedCardHalf rightCopied = rightOriginal.copy();
            this.prepareCardForCopy(rightOriginal, rightCopied, newController);
            copiedParts.add(rightCopied);
            ((ModalDoubleFacedCard)copiedCard).setParts(leftCopied, rightCopied);
        } else if (copiedCard instanceof CardWithSpellOption) {
            SpellOptionCard rightOriginal = ((CardWithSpellOption)copiedCard).getSpellCard();
            SpellOptionCard rightCopied = rightOriginal.copy();
            this.prepareCardForCopy(rightOriginal, rightCopied, newController);
            copiedParts.add(rightCopied);
            ((CardWithSpellOption)copiedCard).setParts(rightCopied);
        }
        this.prepareCardForCopy(mainCardToCopy, copiedCard, newController);
        Zone copyToZone = game.getState().getZone(mainCardToCopy.getId());
        if (copyToZone == Zone.BATTLEFIELD) {
            throw new UnsupportedOperationException("Cards cannot be copied while on the Battlefield");
        }
        copiedParts.forEach(card -> {
            this.copiedCards.put(card.getId(), (Card)card);
            this.addCard((Card)card, copyToZone);
        });
        copiedParts.forEach(card -> this.setValue(COPIED_CARD_KEY + card.getId(), card.copy()));
        return copiedCard;
    }

    private void prepareCardForCopy(Card originalCard, Card copiedCard, UUID newController) {
        copiedCard.assignNewId();
        copiedCard.setOwnerId(newController);
        copiedCard.setCopy(true, originalCard);
    }

    public int getNextPermanentOrderNumber() {
        return this.permanentOrderNumber++;
    }

    public int getApplyEffectsCounter() {
        return this.applyEffectsCounter;
    }

    public void addPowerInsteadOfToughnessForDamageLethalityFilter(UUID source, FilterCreaturePermanent filter) {
        this.usePowerInsteadOfToughnessForDamageLethalityFilters.put(source, filter);
    }

    public List<FilterCreaturePermanent> getActivePowerInsteadOfToughnessForDamageLethalityFilters() {
        return this.usePowerInsteadOfToughnessForDamageLethalityFilters.isEmpty() ? Collections.emptyList() : this.getBattlefield().getAllActivePermanents().stream().map(MageItem::getId).filter(this.usePowerInsteadOfToughnessForDamageLethalityFilters::containsKey).map(this.usePowerInsteadOfToughnessForDamageLethalityFilters::get).collect(Collectors.toList());
    }

    boolean checkCommanderShouldStay(Card card, Game game) {
        return this.commandersToStay.stream().anyMatch(mor -> mor.refersTo(card, game));
    }

    void setCommanderShouldStay(Card card, Game game) {
        this.commandersToStay.add(new MageObjectReference(card, game));
    }

    public void setManaBurn(boolean manaBurn) {
        this.manaBurn = manaBurn;
    }

    public boolean isManaBurn() {
        return this.manaBurn;
    }

    boolean isHasDayNight() {
        return this.hasDayNight;
    }

    boolean setDaytime(boolean daytime) {
        boolean flag = this.hasDayNight && this.isDaytime != daytime;
        this.hasDayNight = true;
        this.isDaytime = daytime;
        return flag;
    }

    boolean isDaytime() {
        return this.isDaytime;
    }

    public String toString() {
        return CardUtil.getTurnInfo(this);
    }

    public boolean setReverseTurnOrder(boolean reverse) {
        this.reverseTurnOrder = this.reverseTurnOrder && reverse ? false : reverse;
        return this.reverseTurnOrder;
    }

    public boolean getReverseTurnOrder() {
        return this.reverseTurnOrder;
    }
}

