/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import mage.game.GameState;
import org.apache.log4j.Logger;

public class GameStates
implements Serializable {
    private static final Logger logger = Logger.getLogger(GameStates.class);
    private final List<GameState> states = new ArrayList<GameState>();

    public void save(GameState gameState) {
        this.states.add(gameState.copy());
    }

    public int getSize() {
        return this.states.size();
    }

    public GameState rollback(int index) {
        if (!this.states.isEmpty() && index < this.states.size()) {
            while (this.states.size() > index + 1) {
                this.states.remove(this.states.size() - 1);
            }
            logger.trace((Object)("Rolling back state: " + index));
            return this.states.get(index);
        }
        return null;
    }

    public int remove(int index) {
        if (!this.states.isEmpty() && index < this.states.size()) {
            while (this.states.size() > index && !this.states.isEmpty()) {
                this.states.remove(this.states.size() - 1);
            }
        }
        return this.states.size();
    }

    public GameState get(int index) {
        if (index < this.states.size()) {
            return this.states.get(index);
        }
        return null;
    }

    public void clear() {
        this.states.clear();
    }
}

