/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.continuous.CommanderReplacementEffect;
import mage.abilities.effects.common.cost.CommanderCostModification;
import mage.cards.Card;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.constants.CommanderCardType;
import mage.constants.MultiplayerAttackOption;
import mage.constants.PhaseStep;
import mage.constants.RangeOfInfluence;
import mage.constants.Zone;
import mage.game.DefaultCommander;
import mage.game.Game;
import mage.game.GameImpl;
import mage.game.mulligan.Mulligan;
import mage.game.turn.TurnMod;
import mage.players.Player;
import mage.util.CardUtil;
import mage.watchers.common.CommanderInfoWatcher;

public abstract class GameTinyLeadersImpl
extends GameImpl {
    protected boolean alsoHand;
    protected boolean alsoLibrary;
    protected boolean startingPlayerSkipsDraw = true;

    public GameTinyLeadersImpl(MultiplayerAttackOption attackOption, RangeOfInfluence range, Mulligan mulligan, int startLife, int startHandSize) {
        super(attackOption, range, mulligan, 50, startLife, startHandSize);
    }

    protected GameTinyLeadersImpl(GameTinyLeadersImpl game) {
        super(game);
        this.alsoHand = game.alsoHand;
        this.startingPlayerSkipsDraw = game.startingPlayerSkipsDraw;
    }

    @Override
    protected void init(UUID choosingPlayerId) {
        for (UUID playerId : this.state.getPlayerList(this.startingPlayerId)) {
            Player player = this.getPlayer(playerId);
            if (player == null) continue;
            String commanderName = player.getMatchPlayer().getDeck().getName();
            Card commander = this.findCommander(this, player, commanderName);
            if (commander != null) {
                commander.moveToZone(Zone.COMMAND, null, this, true);
                continue;
            }
            commander = GameTinyLeadersImpl.getCommanderCard(commanderName, player.getId());
            if (commander != null) {
                HashSet<Card> cards = new HashSet<Card>();
                cards.add(commander);
                this.loadCards(cards, playerId);
                player.addCommanderId(commander.getId());
                commander.moveToZone(Zone.COMMAND, null, this, true);
                SimpleStaticAbility ability = new SimpleStaticAbility(Zone.COMMAND, new InfoEffect("Commander effects"));
                ability.addEffect(new CommanderReplacementEffect(commander.getId(), this.alsoHand, this.alsoLibrary, false, "Commander"));
                ability.addEffect(new CommanderCostModification(commander));
                CommanderInfoWatcher watcher = new CommanderInfoWatcher("Commander", commander.getId(), false);
                this.getState().addWatcher(watcher);
                watcher.addCardInfoToCommander(this);
                this.getState().addAbility((Ability)ability, null);
                continue;
            }
            throw new IllegalStateException("Commander card could not be created. Name: [" + player.getMatchPlayer().getDeck().getName() + ']');
        }
        super.init(choosingPlayerId);
        if (this.startingPlayerSkipsDraw) {
            this.state.getTurnMods().add(new TurnMod(this.startingPlayerId).withSkipStep(PhaseStep.DRAW));
        }
    }

    private Card findCommander(Game game, Player player, String commanderName) {
        return game.getCommanderCardsFromAnyZones(player, CommanderCardType.ANY, Zone.ALL).stream().filter(c -> CardUtil.haveSameNames(c, commanderName, game)).findFirst().orElse(null);
    }

    public static Card getCommanderCard(String commanderName, UUID ownerId) {
        Card commander = null;
        if (commanderName != null) {
            switch (commanderName) {
                case "Sultai": {
                    commander = new DefaultCommander(ownerId, commanderName, "{U}{B}{G}");
                    break;
                }
                case "Glass": {
                    commander = new DefaultCommander(ownerId, commanderName, "{C}{C}{C}");
                    break;
                }
                default: {
                    CardInfo cardInfo = CardRepository.instance.findCard(commanderName);
                    if (cardInfo == null) break;
                    commander = cardInfo.createCard();
                }
            }
        }
        return commander;
    }

    public void setAlsoHand(boolean alsoHand) {
        this.alsoHand = alsoHand;
    }

    public void setAlsoLibrary(boolean alsoLibrary) {
        this.alsoLibrary = alsoLibrary;
    }
}

