/*
 * Decompiled with CFR 0.152.
 */
package mage.game.combat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.common.ControllerAssignCombatDamageToBlockersAbility;
import mage.abilities.common.ControllerDivideCombatDamageAbility;
import mage.abilities.common.DamageAsThoughNotBlockedAbility;
import mage.abilities.keyword.BandingAbility;
import mage.abilities.keyword.BandsWithOtherAbility;
import mage.abilities.keyword.CantBlockAloneAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.TrampleOverPlaneswalkersAbility;
import mage.constants.AsThoughEffectType;
import mage.constants.MultiAmountType;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.BlockerDeclaredEvent;
import mage.game.events.DeclareBlockerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.Copyable;
import mage.util.MultiAmountMessage;
import mage.watchers.common.FirstStrikeWatcher;

public class CombatGroup
implements Serializable,
Copyable<CombatGroup> {
    protected List<UUID> attackers = new ArrayList<UUID>();
    protected List<UUID> formerAttackers = new ArrayList<UUID>();
    protected List<UUID> blockers = new ArrayList<UUID>();
    protected Map<UUID, UUID> players = new HashMap<UUID, UUID>();
    protected boolean blocked;
    protected UUID defenderId;
    protected UUID defendingPlayerId;
    protected boolean defenderIsPermanent;

    public CombatGroup(UUID defenderId, boolean defenderIsPermanent, UUID defendingPlayerId) {
        this.defenderId = defenderId;
        this.defenderIsPermanent = defenderIsPermanent;
        this.defendingPlayerId = defendingPlayerId;
    }

    protected CombatGroup(CombatGroup group) {
        this.attackers.addAll(group.attackers);
        this.formerAttackers.addAll(group.formerAttackers);
        this.blockers.addAll(group.blockers);
        this.players.putAll(group.players);
        this.blocked = group.blocked;
        this.defenderId = group.defenderId;
        this.defendingPlayerId = group.defendingPlayerId;
        this.defenderIsPermanent = group.defenderIsPermanent;
    }

    public boolean hasFirstOrDoubleStrike(Game game) {
        return Stream.concat(this.attackers.stream(), this.blockers.stream()).map(game::getPermanent).filter(Objects::nonNull).anyMatch(CombatGroup::hasFirstOrDoubleStrike);
    }

    public UUID getDefenderId() {
        return this.defenderId;
    }

    public UUID getDefendingPlayerId() {
        return this.defendingPlayerId;
    }

    public List<UUID> getAttackers() {
        return this.attackers;
    }

    public List<UUID> getFormerAttackers() {
        return this.formerAttackers;
    }

    public List<UUID> getBlockers() {
        return this.blockers;
    }

    private static boolean hasFirstOrDoubleStrike(Permanent perm) {
        return CombatGroup.hasFirstStrike(perm) || CombatGroup.hasDoubleStrike(perm);
    }

    private static boolean hasFirstStrike(Permanent perm) {
        return perm.getAbilities().containsKey(FirstStrikeAbility.getInstance().getId());
    }

    private static boolean hasDoubleStrike(Permanent perm) {
        return perm.getAbilities().containsKey(DoubleStrikeAbility.getInstance().getId());
    }

    private static boolean hasTrample(Permanent perm) {
        return perm.getAbilities().containsKey(TrampleAbility.getInstance().getId());
    }

    private static boolean hasTrampleOverPlaneswalkers(Permanent perm) {
        return perm.getAbilities().containsKey(TrampleOverPlaneswalkersAbility.getInstance().getId());
    }

    private static boolean hasBanding(Permanent perm) {
        return perm.getAbilities().containsKey(BandingAbility.getInstance().getId());
    }

    private boolean appliesBandsWithOther(List<UUID> creatureIds, Game game) {
        for (UUID creatureId : creatureIds) {
            Permanent perm = game.getPermanent(creatureId);
            if (perm == null || perm.getBandedCards() == null) continue;
            for (Ability ab : perm.getAbilities()) {
                Permanent banded;
                if (!ab.getClass().equals(BandsWithOtherAbility.class)) continue;
                BandsWithOtherAbility ability = (BandsWithOtherAbility)ab;
                if (ability.getSubtype() != null && perm.hasSubtype(ability.getSubtype(), game)) {
                    for (UUID bandedId : creatureIds) {
                        if (bandedId.equals(creatureId) || (banded = game.getPermanent(bandedId)) == null || !banded.hasSubtype(ability.getSubtype(), game)) continue;
                        return true;
                    }
                }
                if (ability.getSupertype() != null && perm.getSuperType(game).contains((Object)ability.getSupertype())) {
                    for (UUID bandedId : creatureIds) {
                        if (bandedId.equals(creatureId) || (banded = game.getPermanent(bandedId)) == null || !banded.getSuperType(game).contains((Object)ability.getSupertype())) continue;
                        return true;
                    }
                }
                if (ability.getName() == null || !perm.getName().equals(ability.getName())) continue;
                for (UUID bandedId : creatureIds) {
                    if (bandedId.equals(creatureId) || (banded = game.getPermanent(bandedId)) == null || !banded.getName().equals(ability.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void assignDamageToBlockers(boolean first, Game game) {
        Permanent attacker;
        if (!(this.attackers.isEmpty() || first && !this.hasFirstOrDoubleStrike(game) || (attacker = game.getPermanent(this.attackers.get(0))) == null || this.assignsDefendingPlayerAndOrDefendingCreaturesDividedDamage(attacker, attacker.getControllerId(), first, game, true))) {
            if (this.blockers.isEmpty()) {
                this.unblockedDamage(first, game);
            } else {
                Player player = game.getPlayer(this.defenderAssignsCombatDamage(game) ? this.defendingPlayerId : attacker.getControllerId());
                if (attacker.getAbilities().containsKey(DamageAsThoughNotBlockedAbility.getInstance().getId()) && player.chooseUse(Outcome.Damage, "Have " + attacker.getLogName() + " assign damage as though it weren't blocked?", null, game) || !game.getContinuousEffects().asThough(attacker.getId(), AsThoughEffectType.DAMAGE_NOT_BLOCKED, null, attacker.getControllerId(), game).isEmpty()) {
                    this.blocked = false;
                    this.unblockedDamage(first, game);
                }
                this.blockerDamage(player, first, game);
            }
        }
    }

    public void assignDamageToAttackers(boolean first, Game game) {
        if (!(this.blockers.isEmpty() || first && !this.hasFirstOrDoubleStrike(game))) {
            for (UUID blockerId : this.blockers) {
                Permanent blocker = game.getPermanent(blockerId);
                if (!this.assignsDefendingPlayerAndOrDefendingCreaturesDividedDamage(blocker, blocker.getControllerId(), first, game, false)) continue;
                return;
            }
            if (this.attackers.size() != 1) {
                this.attackerDamage(first, game);
            }
        }
    }

    public void applyDamage(Game game) {
        Permanent permanent;
        Permanent permanent2;
        for (UUID uuid : this.attackers) {
            permanent2 = game.getPermanent(uuid);
            if (permanent2 == null) continue;
            permanent2.applyDamage(game);
        }
        for (UUID uuid : this.blockers) {
            permanent2 = game.getPermanent(uuid);
            if (permanent2 == null) continue;
            permanent2.applyDamage(game);
        }
        if (this.defenderIsPermanent && (permanent = game.getPermanent(this.defenderId)) != null) {
            permanent.applyDamage(game);
        }
    }

    public static boolean dealsDamageThisStep(Permanent perm, boolean first, Game game) {
        if (perm == null) {
            return false;
        }
        if (first) {
            if (CombatGroup.hasFirstOrDoubleStrike(perm)) {
                FirstStrikeWatcher.recordFirstStrikingCreature(perm.getId(), game);
                return true;
            }
            return false;
        }
        return CombatGroup.hasDoubleStrike(perm) || !FirstStrikeWatcher.wasFirstStrikingCreature(perm.getId(), game);
    }

    private void unblockedDamage(boolean first, Game game) {
        for (UUID attackerId : this.attackers) {
            Permanent attacker = game.getPermanent(attackerId);
            if (!CombatGroup.dealsDamageThisStep(attacker, first, game) || this.blocked && !CombatGroup.hasTrample(attacker)) continue;
            this.defenderDamage(attacker, this.getDamageValueFromPermanent(attacker, game), game, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void blockerDamage(Player player, boolean first, Game game) {
        Permanent attacker = game.getPermanent(this.attackers.get(0));
        if (attacker == null) {
            return;
        }
        int damage = this.getDamageValueFromPermanent(attacker, game);
        if (CombatGroup.dealsDamageThisStep(attacker, first, game)) {
            Permanent blocker;
            HashMap<UUID, Integer> blockerPower = new HashMap<UUID, Integer>();
            for (UUID blockerId : this.blockers) {
                Permanent blocker2 = game.getPermanent(blockerId);
                if (!CombatGroup.dealsDamageThisStep(blocker2, first, game) || !this.checkSoleBlockerAfter(blocker2, game)) continue;
                blockerPower.put(blockerId, this.getDamageValueFromPermanent(blocker2, game));
            }
            HashMap assigned = new HashMap();
            ArrayList<MultiAmountMessage> damageDivision = new ArrayList<MultiAmountMessage>();
            ArrayList<UUID> blockersCopy = new ArrayList<UUID>(this.blockers);
            if (this.blocked) {
                MultiAmountType dialogue;
                int remainingDamage = damage;
                for (UUID blockerId : this.blockers) {
                    blocker = game.getPermanent(blockerId);
                    if (blocker == null) continue;
                    int defaultDamage = Math.min(remainingDamage, blocker.getLethalDamage(attacker.getId(), game));
                    remainingDamage -= defaultDamage;
                    String message = String.format("%s, P/T: %d/%d", blocker.getLogName(), blocker.getPower().getValue(), blocker.getToughness().getValue());
                    damageDivision.add(new MultiAmountMessage(message, 0, damage, defaultDamage));
                }
                if (CombatGroup.hasTrample(attacker)) {
                    void var11_18;
                    if (remainingDamage > 0 || damageDivision.size() > 1) {
                        dialogue = new MultiAmountType("Assign combat damage (with trample)", String.format("Assign combat damage among creatures blocking %s, P/T: %d/%d (Unassigned damage tramples through)", attacker.getLogName(), attacker.getPower().getValue(), attacker.getToughness().getValue()));
                        List<Integer> list = player.getMultiAmountWithIndividualConstraints(Outcome.Damage, damageDivision, damage - remainingDamage, damage, dialogue, game);
                    } else {
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        if (damageDivision.size() == 1) {
                            arrayList.add(damage);
                        }
                    }
                    int trampleDamage = damage - var11_18.stream().mapToInt(x -> x).sum();
                    if (trampleDamage > 0) {
                        this.defenderDamage(attacker, trampleDamage, game, false);
                    }
                } else {
                    if (remainingDamage > 0) {
                        ((MultiAmountMessage)damageDivision.get((int)0)).defaultValue += remainingDamage;
                    }
                    if (damageDivision.size() > 1) {
                        dialogue = new MultiAmountType("Assign combat damage", String.format("Assign combat damage among creatures blocking %s, P/T: %d/%d", attacker.getLogName(), attacker.getPower().getValue(), attacker.getToughness().getValue()));
                        List<Integer> list = player.getMultiAmountWithIndividualConstraints(Outcome.Damage, damageDivision, damage, damage, dialogue, game);
                    } else {
                        LinkedList<Integer> linkedList = new LinkedList<Integer>();
                        if (damageDivision.size() == 1) {
                            linkedList.add(damage);
                        }
                    }
                }
                if (!damageDivision.isEmpty()) {
                    for (int i = 0; i < blockersCopy.size(); ++i) {
                        void var11_21;
                        assigned.put(blockersCopy.get(i), var11_21.get(i));
                    }
                }
            }
            for (UUID uUID : this.blockers) {
                Integer power = (Integer)blockerPower.get(uUID);
                if (power == null || (blocker = game.getPermanent(uUID)) == null || this.assignsDefendingPlayerAndOrDefendingCreaturesDividedDamage(blocker, blocker.getControllerId(), first, game, false)) continue;
                attacker.markDamage(power, uUID, null, game, true, true);
            }
            for (Map.Entry entry : assigned.entrySet()) {
                Permanent blocker3 = game.getPermanent((UUID)entry.getKey());
                if (blocker3 == null) continue;
                blocker3.markDamage((Integer)entry.getValue(), attacker.getId(), null, game, true, true);
            }
        } else {
            for (UUID blockerId : this.blockers) {
                Permanent blocker = game.getPermanent(blockerId);
                if (!CombatGroup.dealsDamageThisStep(blocker, first, game) || this.assignsDefendingPlayerAndOrDefendingCreaturesDividedDamage(blocker, blocker.getControllerId(), first, game, false)) continue;
                attacker.markDamage(this.getDamageValueFromPermanent(blocker, game), blocker.getId(), null, game, true, true);
            }
        }
    }

    private void defendingPlayerAndOrDefendingCreaturesDividedDamage(Permanent attacker, Player player, boolean first, Game game, boolean isAttacking) {
        block8: {
            block9: {
                Player player2;
                if (this.blocked && this.blockers.isEmpty() && isAttacking || this.attackers.isEmpty() && !isAttacking) break block8;
                if (attacker == null) {
                    return;
                }
                int damage = this.getDamageValueFromPermanent(attacker, game);
                if (!CombatGroup.dealsDamageThisStep(attacker, first, game)) break block9;
                HashMap<UUID, Integer> blockerPower = new HashMap<UUID, Integer>();
                for (UUID uUID : this.blockers) {
                    Permanent blocker = game.getPermanent(uUID);
                    if (!CombatGroup.dealsDamageThisStep(blocker, first, game) || !this.checkSoleBlockerAfter(blocker, game)) continue;
                    blockerPower.put(uUID, this.getDamageValueFromPermanent(blocker, game));
                }
                HashMap<UUID, Integer> assigned = new HashMap<UUID, Integer>();
                for (Permanent defendingCreature : game.getBattlefield().getAllActivePermanents(StaticFilters.FILTER_PERMANENT_CREATURE, this.defendingPlayerId, game)) {
                    if (defendingCreature == null) continue;
                    if (damage <= 0) break;
                    int damageAssigned = 0;
                    damageAssigned = player.getAmount(0, damage, "Assign damage to " + defendingCreature.getName(), null, game);
                    assigned.put(defendingCreature.getId(), damageAssigned);
                    damage -= damageAssigned;
                }
                if (damage > 0 && (player2 = game.getPlayer(this.defendingPlayerId)) != null) {
                    player2.damage(damage, attacker.getId(), null, game, true, true);
                }
                if (isAttacking) {
                    for (UUID blockerId : this.blockers) {
                        Permanent blocker;
                        Integer power = (Integer)blockerPower.get(blockerId);
                        if (power == null || this.assignsDefendingPlayerAndOrDefendingCreaturesDividedDamage(blocker = game.getPermanent(blockerId), blocker.getControllerId(), first, game, false)) continue;
                        attacker.markDamage(power, blockerId, null, game, true, true);
                    }
                }
                for (Map.Entry entry : assigned.entrySet()) {
                    Permanent defendingCreature = game.getPermanent((UUID)entry.getKey());
                    defendingCreature.markDamage((Integer)entry.getValue(), attacker.getId(), null, game, true, true);
                }
                break block8;
            }
            if (!isAttacking) break block8;
            for (UUID blockerId : this.blockers) {
                Permanent permanent = game.getPermanent(blockerId);
                if (!CombatGroup.dealsDamageThisStep(permanent, first, game) || this.assignsDefendingPlayerAndOrDefendingCreaturesDividedDamage(permanent, permanent.getControllerId(), first, game, false)) continue;
                attacker.markDamage(this.getDamageValueFromPermanent(permanent, game), permanent.getId(), null, game, true, true);
            }
        }
    }

    public boolean checkSoleBlockerAfter(Permanent blocker, Game game) {
        if (blocker.getBlocking() == 1) {
            if (game.getCombat().blockingGroups.get(blocker.getId()) == null) {
                return true;
            }
            for (CombatGroup group : game.getCombat().getBlockingGroups()) {
                if (!group.blockers.contains(blocker.getId()) || group.attackers.size() != 1) continue;
                return true;
            }
        }
        return false;
    }

    private void attackerDamage(boolean first, Game game) {
        Permanent blocker = game.getPermanent(this.blockers.get(0));
        if (blocker == null) {
            return;
        }
        Player player = game.getPlayer(this.attackerAssignsCombatDamage(game) ? game.getCombat().getAttackingPlayerId() : blocker.getControllerId());
        int damage = this.getDamageValueFromPermanent(blocker, game);
        if (CombatGroup.dealsDamageThisStep(blocker, first, game)) {
            List<Integer> amounts;
            HashMap assigned = new HashMap();
            ArrayList<MultiAmountMessage> damageDivision = new ArrayList<MultiAmountMessage>();
            ArrayList<UUID> attackersCopy = new ArrayList<UUID>(this.attackers);
            int remainingDamage = damage;
            for (UUID attackerId : this.attackers) {
                Permanent attacker = game.getPermanent(attackerId);
                if (attacker == null) continue;
                int defaultDamage = Math.min(remainingDamage, attacker.getLethalDamage(blocker.getId(), game));
                remainingDamage -= defaultDamage;
                String message = String.format("%s, P/T: %d/%d", attacker.getLogName(), attacker.getPower().getValue(), attacker.getToughness().getValue());
                damageDivision.add(new MultiAmountMessage(message, 0, damage, defaultDamage));
            }
            if (remainingDamage > 0) {
                ((MultiAmountMessage)damageDivision.get((int)0)).defaultValue += remainingDamage;
            }
            if (damageDivision.size() > 1) {
                MultiAmountType dialogue = new MultiAmountType("Assign blocker combat damage", String.format("Assign combat damage among creatures blocked by %s, P/T: %d/%d", blocker.getLogName(), blocker.getPower().getValue(), blocker.getToughness().getValue()));
                amounts = player.getMultiAmountWithIndividualConstraints(Outcome.Damage, damageDivision, damage, damage, dialogue, game);
            } else {
                amounts = new LinkedList<Integer>();
                amounts.add(damage);
            }
            if (!damageDivision.isEmpty()) {
                for (int i = 0; i < attackersCopy.size(); ++i) {
                    assigned.put(attackersCopy.get(i), amounts.get(i));
                }
            }
            for (Map.Entry entry : assigned.entrySet()) {
                Permanent attacker = game.getPermanent((UUID)entry.getKey());
                if (attacker == null) continue;
                attacker.markDamage((Integer)entry.getValue(), blocker.getId(), null, game, true, true);
            }
        }
    }

    private void defenderDamage(Permanent attacker, int amount, Game game, boolean damageToDefenderController) {
        UUID affectedDefenderId = damageToDefenderController ? game.getControllerId(this.defenderId) : this.defenderId;
        Permanent permanent = game.getPermanent(affectedDefenderId);
        if (permanent == null) {
            Player defender = game.getPlayer(affectedDefenderId);
            if (defender != null) {
                defender.damage(amount, attacker.getId(), null, game, true, true);
            }
            return;
        }
        if (permanent.isPlaneswalker(game) && CombatGroup.hasTrampleOverPlaneswalkers(attacker)) {
            int lethalDamage = permanent.getLethalDamage(attacker.getId(), game);
            if (lethalDamage >= amount) {
                permanent.markDamage(amount, attacker.getId(), null, game, true, true);
            } else {
                permanent.markDamage(lethalDamage, attacker.getId(), null, game, true, true);
                if ((amount -= lethalDamage) > 0) {
                    this.defenderDamage(attacker, amount, game, true);
                }
            }
        } else {
            permanent.markDamage(amount, attacker.getId(), null, game, true, true);
        }
    }

    public boolean canBlock(Permanent blocker, Game game) {
        if (!this.defendingPlayerId.equals(blocker.getControllerId())) {
            return false;
        }
        for (UUID attackerId : this.attackers) {
            if (blocker.canBlock(attackerId, game)) continue;
            return false;
        }
        return true;
    }

    public void addBlocker(UUID blockerId, UUID playerId, Game game) {
        for (UUID attackerId : this.attackers) {
            if (!game.replaceEvent(new DeclareBlockerEvent(attackerId, blockerId, playerId))) continue;
            return;
        }
        this.addBlockerToGroup(blockerId, playerId, game);
    }

    public void addBlockerToGroup(UUID blockerId, UUID playerId, Game game) {
        Permanent blocker = game.getPermanent(blockerId);
        if (blockerId != null && blocker != null) {
            blocker.setBlocking(blocker.getBlocking() + 1);
            this.blockers.add(blockerId);
            this.blocked = true;
            this.players.put(blockerId, playerId);
        }
    }

    private void logDamageAssignmentOrder(String prefix, List<UUID> assignedFor, List<UUID> assignedOrder, Game game) {
        Permanent perm;
        StringBuilder sb = new StringBuilder(prefix);
        boolean first = true;
        for (UUID id : assignedFor) {
            perm = game.getPermanent(id);
            if (perm == null) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(perm.getLogName());
            first = false;
        }
        sb.append(" are ordered: ");
        first = true;
        for (UUID id : assignedOrder) {
            perm = game.getPermanent(id);
            if (perm == null) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(perm.getLogName());
            first = false;
        }
        game.informPlayers(sb.toString());
    }

    public boolean isDefenderIsPermanent() {
        return this.defenderIsPermanent;
    }

    public boolean removeAttackedPermanent(UUID permanentId) {
        if (this.defenderIsPermanent && this.defenderId.equals(permanentId)) {
            this.defenderId = null;
            return true;
        }
        return false;
    }

    public boolean remove(UUID creatureId) {
        boolean result = false;
        if (this.attackers.contains(creatureId)) {
            this.formerAttackers.add(creatureId);
            this.attackers.remove(creatureId);
            result = true;
        } else if (this.blockers.contains(creatureId)) {
            this.blockers.remove(creatureId);
            result = true;
        }
        return result;
    }

    public void acceptBlockers(Game game) {
        if (this.attackers.isEmpty()) {
            return;
        }
        for (UUID blockerId : this.blockers) {
            for (UUID attackerId : this.attackers) {
                game.fireEvent(new BlockerDeclaredEvent(attackerId, blockerId, this.players.get(blockerId)));
            }
        }
        if (!this.blockers.isEmpty()) {
            for (UUID attackerId : this.attackers) {
                game.fireEvent(GameEvent.getEvent(GameEvent.EventType.CREATURE_BLOCKED, attackerId, null));
            }
        }
    }

    public boolean checkBlockRestrictions(Game game, Player defender, int blockersCount) {
        Permanent attacker;
        boolean blockWasLegal = true;
        if (this.attackers.isEmpty()) {
            return blockWasLegal;
        }
        HashMap<UUID, Set<Object>> possibleBlockers = new HashMap<UUID, Set<Object>>();
        for (UUID uUID : this.attackers) {
            attacker = game.getPermanent(uUID);
            HashSet<UUID> goodBlockers = new HashSet<UUID>();
            for (Permanent blocker : game.getBattlefield().getActivePermanents(StaticFilters.FILTER_PERMANENT_CREATURES_CONTROLLED, defender.getId(), game)) {
                if (!blocker.canBlock(uUID, game)) continue;
                goodBlockers.add(blocker.getId());
            }
            possibleBlockers.put(attacker.getId(), goodBlockers);
        }
        if (blockersCount == 1) {
            ArrayList<UUID> toBeRemoved = new ArrayList<UUID>();
            for (UUID blockerId : this.getBlockers()) {
                Permanent blocker = game.getPermanent(blockerId);
                if (blocker == null || !blocker.getAbilities().containsKey(CantBlockAloneAbility.getInstance().getId())) continue;
                blockWasLegal = false;
                if (!game.isSimulation()) {
                    game.informPlayers(blocker.getLogName() + " can't block alone. Removing it from combat.");
                }
                toBeRemoved.add(blockerId);
            }
            for (UUID blockerId : toBeRemoved) {
                game.getCombat().removeBlocker(blockerId, game);
            }
            if (this.blockers.isEmpty()) {
                this.blocked = false;
            }
        }
        for (UUID uUID : this.attackers) {
            attacker = game.getPermanent(uUID);
            if (attacker == null || !this.blocked) continue;
            if (attacker.getMinBlockedBy() > 1 && !this.blockers.isEmpty() && this.blockers.size() < attacker.getMinBlockedBy()) {
                for (UUID blockerId : new ArrayList<UUID>(this.blockers)) {
                    game.getCombat().removeBlocker(blockerId, game);
                }
                this.blockers.clear();
                if (!game.isSimulation()) {
                    game.informPlayers(attacker.getLogName() + " can't be blocked except by " + attacker.getMinBlockedBy() + " or more creatures. Blockers discarded.");
                }
                if (attacker.getMinBlockedBy() <= possibleBlockers.getOrDefault(attacker.getId(), Collections.emptySet()).size()) {
                    blockWasLegal = false;
                }
            }
            if (attacker.getMaxBlockedBy() <= 0 || attacker.getMaxBlockedBy() >= this.blockers.size()) continue;
            for (UUID blockerId : new ArrayList<UUID>(this.blockers)) {
                game.getCombat().removeBlocker(blockerId, game);
            }
            this.blockers.clear();
            if (!game.isSimulation()) {
                game.informPlayers(attacker.getLogName() + " can't be blocked by more than " + attacker.getMaxBlockedBy() + (attacker.getMaxBlockedBy() == 1 ? " creature." : " creatures.") + " Blockers discarded.");
            }
            blockWasLegal = false;
        }
        return blockWasLegal;
    }

    private int getDamageValueFromPermanent(Permanent permanent, Game game) {
        if (game.getCombat().useToughnessForDamage(permanent, game)) {
            return Math.max(0, permanent.getToughness().getValue());
        }
        return Math.max(0, permanent.getPower().getValue());
    }

    public void setBlocked(boolean blocked, Game game) {
        this.blocked = blocked;
        for (UUID attackerId : this.attackers) {
            Permanent attacker = game.getPermanent(attackerId);
            if (attacker == null) continue;
            for (UUID bandedId : attacker.getBandedCards()) {
                CombatGroup bandedGroup;
                if (bandedId.equals(attackerId) || (bandedGroup = game.getCombat().findGroup(bandedId)) == null) continue;
                bandedGroup.blocked = blocked;
            }
        }
    }

    public boolean getBlocked() {
        return this.blocked;
    }

    @Override
    public CombatGroup copy() {
        return new CombatGroup(this);
    }

    public boolean changeDefenderPostDeclaration(UUID newDefenderId, Game game) {
        if (this.defenderId.equals(newDefenderId)) {
            return false;
        }
        for (UUID attackerId : this.attackers) {
            Permanent attacker = game.getPermanent(attackerId);
            if (attacker == null) continue;
            if (attacker.getBandedCards() != null) {
                for (UUID bandedId : attacker.getBandedCards()) {
                    Permanent banded = game.getPermanent(bandedId);
                    if (banded == null) continue;
                    banded.removeBandedCard(attackerId);
                }
            }
            attacker.clearBandedCards();
        }
        Permanent permanent = game.getPermanent(newDefenderId);
        if (permanent != null) {
            this.defenderId = newDefenderId;
            this.defendingPlayerId = permanent.isBattle(game) ? permanent.getProtectorId() : permanent.getControllerId();
            this.defenderIsPermanent = true;
            return true;
        }
        Player defender = game.getPlayer(newDefenderId);
        if (defender == null) {
            return false;
        }
        this.defenderId = newDefenderId;
        this.defendingPlayerId = newDefenderId;
        this.defenderIsPermanent = false;
        return true;
    }

    public boolean attackerAssignsCombatDamage(Game game) {
        for (UUID attackerId : this.attackers) {
            Permanent attacker = game.getPermanent(attackerId);
            if (attacker == null || !CombatGroup.hasBanding(attacker)) continue;
            return true;
        }
        return this.appliesBandsWithOther(this.attackers, game);
    }

    public boolean defenderAssignsCombatDamage(Game game) {
        for (UUID blockerId : this.blockers) {
            Permanent blocker = game.getPermanent(blockerId);
            if (blocker == null || !CombatGroup.hasBanding(blocker)) continue;
            return true;
        }
        if (this.appliesBandsWithOther(this.blockers, game)) {
            return true;
        }
        for (Permanent defensiveFormation : game.getBattlefield().getAllActivePermanents(this.defendingPlayerId)) {
            if (!defensiveFormation.getAbilities().containsKey(ControllerAssignCombatDamageToBlockersAbility.getInstance().getId())) continue;
            return true;
        }
        return false;
    }

    public boolean assignsDefendingPlayerAndOrDefendingCreaturesDividedDamage(Permanent creature, UUID playerId, boolean first, Game game, boolean isAttacking) {
        if (creature.getAbilities().containsKey(ControllerDivideCombatDamageAbility.getInstance().getId())) {
            Player player = game.getPlayer(this.defenderAssignsCombatDamage(game) ? this.defendingPlayerId : (!isAttacking && this.attackerAssignsCombatDamage(game) ? game.getCombat().getAttackingPlayerId() : playerId));
            if (!(this.blocked && this.blockers.isEmpty() && isAttacking || this.attackers.isEmpty() && !isAttacking || !CombatGroup.dealsDamageThisStep(creature, first, game) || !player.chooseUse(Outcome.Damage, "Have " + creature.getLogName() + " assign its combat damage divided among defending player and/or any number of defending creatures?", null, game))) {
                this.defendingPlayerAndOrDefendingCreaturesDividedDamage(creature, player, first, game, isAttacking);
                return true;
            }
        }
        return false;
    }

    private static int getLethalDamage(Permanent blocker, Permanent attacker, Game game) {
        return blocker.getLethalDamage(attacker.getId(), game);
    }

    public String toString() {
        return String.format("%d attackers, %d blockers", this.getAttackers().size(), this.getBlockers().size());
    }
}

