/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.dungeons;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.assignment.common.CardTypeAssignment;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.command.dungeons.TombOfAnnihilationDungeon;
import mage.game.permanent.Permanent;
import mage.target.common.TargetSacrifice;

class OublietteTarget
extends TargetSacrifice {
    private static final CardTypeAssignment cardTypeAssigner = new CardTypeAssignment(CardType.ARTIFACT, CardType.CREATURE, CardType.LAND);
    private static final FilterControlledPermanent filter = TombOfAnnihilationDungeon.filter.copy();

    OublietteTarget(int numTargets) {
        super(numTargets, filter);
    }

    private OublietteTarget(OublietteTarget target) {
        super(target);
    }

    @Override
    public OublietteTarget copy() {
        return new OublietteTarget(this);
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set<UUID> possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        CardsImpl existingTargets = new CardsImpl((Collection<UUID>)this.getTargets());
        possibleTargets.removeIf(id -> {
            Permanent permanent = game.getPermanent((UUID)id);
            if (permanent == null) {
                return true;
            }
            Cards newTargets = existingTargets.copy();
            newTargets.add(permanent);
            return cardTypeAssigner.getRoleCount(newTargets, game) < newTargets.size();
        });
        return possibleTargets;
    }

    static int checkTargetCount(Ability source, Game game) {
        List<Permanent> permanents = game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game);
        return cardTypeAssigner.getRoleCount(new CardsImpl(permanents), game);
    }

    static {
        filter.setMessage("an artifact, a creature, and a land");
    }
}

