/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.dungeons;

import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.abilities.effects.common.combat.GoadTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.abilities.effects.keyword.ScryEffect;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.game.command.Dungeon;
import mage.game.command.DungeonRoom;
import mage.game.command.dungeons.ThroneOfTheDeadThreeEffect;
import mage.game.permanent.token.SkeletonMenaceToken;
import mage.game.permanent.token.TreasureToken;
import mage.target.TargetPlayer;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCreaturePermanent;

public class UndercityDungeon
extends Dungeon {
    public UndercityDungeon() {
        super("Undercity");
        DungeonRoom secretEntrance = new DungeonRoom("Secret Entrance", new SearchLibraryPutInHandEffect(new TargetCardInLibrary(StaticFilters.FILTER_CARD_BASIC_LAND), true));
        DungeonRoom forge = new DungeonRoom("Forge", new AddCountersTargetEffect(CounterType.P1P1.createInstance(2)));
        forge.addTarget(new TargetCreaturePermanent());
        DungeonRoom lostWell = new DungeonRoom("Lost Well", new ScryEffect(2, false));
        DungeonRoom trap = new DungeonRoom("Trap!", new LoseLifeTargetEffect(5));
        trap.addTarget(new TargetPlayer());
        DungeonRoom arena = new DungeonRoom("Arena", new GoadTargetEffect());
        arena.addTarget(new TargetCreaturePermanent());
        DungeonRoom stash = new DungeonRoom("Stash", new CreateTokenEffect(new TreasureToken()));
        DungeonRoom archives = new DungeonRoom("Archives", new DrawCardSourceControllerEffect(1));
        DungeonRoom catacombs = new DungeonRoom("Catacombs", new CreateTokenEffect(new SkeletonMenaceToken()));
        DungeonRoom throneOfTheDeadThree = new DungeonRoom("Throne of the Dead Three", new ThroneOfTheDeadThreeEffect());
        secretEntrance.addNextRoom(forge);
        secretEntrance.addNextRoom(lostWell);
        forge.addNextRoom(trap);
        forge.addNextRoom(arena);
        lostWell.addNextRoom(arena);
        lostWell.addNextRoom(stash);
        trap.addNextRoom(archives);
        arena.addNextRoom(archives);
        arena.addNextRoom(catacombs);
        stash.addNextRoom(catacombs);
        archives.addNextRoom(throneOfTheDeadThree);
        catacombs.addNextRoom(throneOfTheDeadThree);
        this.addRoom(secretEntrance);
        this.addRoom(forge);
        this.addRoom(lostWell);
        this.addRoom(trap);
        this.addRoom(arena);
        this.addRoom(stash);
        this.addRoom(archives);
        this.addRoom(catacombs);
        this.addRoom(throneOfTheDeadThree);
    }

    private UndercityDungeon(UndercityDungeon dungeon) {
        super(dungeon);
    }

    @Override
    public UndercityDungeon copy() {
        return new UndercityDungeon(this);
    }
}

