/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class AjaniSteadfastPreventEffect
extends PreventionEffectImpl {
    public AjaniSteadfastPreventEffect() {
        super(Duration.EndOfGame);
        this.staticText = "If a source would deal damage to you or a planeswalker you control, prevent all but 1 of that damage";
        this.consumable = false;
    }

    public AjaniSteadfastPreventEffect(AjaniSteadfastPreventEffect effect) {
        super(effect);
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int damage = event.getAmount();
        if (damage > 1) {
            this.amountToPrevent = damage - 1;
            this.preventDamageAction(event, source, game);
        }
        return false;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        if (event.getType() == GameEvent.EventType.DAMAGE_PLAYER && event.getTargetId().equals(source.getControllerId())) {
            return super.applies(event, source, game);
        }
        if (event.getType() == GameEvent.EventType.DAMAGE_PERMANENT && (permanent = game.getPermanent(event.getTargetId())) != null && permanent.isPlaneswalker(game) && permanent.isControlledBy(source.getControllerId())) {
            return super.applies(event, source, game);
        }
        return false;
    }

    @Override
    public AjaniSteadfastPreventEffect copy() {
        return new AjaniSteadfastPreventEffect(this);
    }
}

