/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import java.util.List;
import mage.abilities.common.SpellCastOpponentTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.FilterSpell;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.watchers.common.SpellsCastWatcher;

class JaceUnravelerOfSecretsTriggeredAbility
extends SpellCastOpponentTriggeredAbility {
    public JaceUnravelerOfSecretsTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.COMMAND, effect, new FilterSpell(), optional);
    }

    public JaceUnravelerOfSecretsTriggeredAbility(SpellCastOpponentTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public SpellCastOpponentTriggeredAbility copy() {
        return new JaceUnravelerOfSecretsTriggeredAbility(this);
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        List<Spell> spells;
        SpellsCastWatcher watcher;
        if (super.checkTrigger(event, game) && (watcher = game.getState().getWatcher(SpellsCastWatcher.class)) != null && (spells = watcher.getSpellsCastThisTurn(event.getPlayerId())) != null && spells.size() == 1) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer(new FixedTarget(event.getTargetId()));
            }
            return true;
        }
        return false;
    }

    @Override
    public String getRule() {
        return "Whenever an opponent casts their first spell each turn, counter that spell.";
    }
}

