/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class LukeSkywalkerEmblemEffect
extends PreventionEffectImpl {
    public LukeSkywalkerEmblemEffect() {
        super(Duration.Custom, Integer.MAX_VALUE, false);
        this.staticText = "Prevent all damage that would be dealt to you during combat";
    }

    protected LukeSkywalkerEmblemEffect(LukeSkywalkerEmblemEffect effect) {
        super(effect);
    }

    @Override
    public LukeSkywalkerEmblemEffect copy() {
        return new LukeSkywalkerEmblemEffect(this);
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller;
        return game.getTurnPhaseType() == TurnPhase.COMBAT && super.applies(event, source, game) && event.getType() == GameEvent.EventType.DAMAGE_PLAYER && (controller = game.getPlayer(source.getControllerId())) != null && game.getState().getPlayersInRange(controller.getId(), game).contains(event.getTargetId());
    }
}

