/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class SerraTheBenevolentEmblemEffect
extends ReplacementEffectImpl {
    SerraTheBenevolentEmblemEffect() {
        super(Duration.Custom, Outcome.Benefit);
        this.staticText = "If you control a creature, damage that would reduce your life total to less than 1 reduces it to 1 instead";
    }

    private SerraTheBenevolentEmblemEffect(SerraTheBenevolentEmblemEffect effect) {
        super(effect);
    }

    @Override
    public SerraTheBenevolentEmblemEffect copy() {
        return new SerraTheBenevolentEmblemEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_CAUSES_LIFE_LOSS;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller;
        if (source.isControlledBy(event.getPlayerId()) && (controller = game.getPlayer(source.getControllerId())) != null && controller.getLife() - event.getAmount() < 1 && game.getBattlefield().count(StaticFilters.FILTER_CONTROLLED_CREATURE, event.getPlayerId(), source, game) > 0) {
            event.setAmount(controller.getLife() - 1);
        }
        return false;
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return false;
    }
}

