/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.command.Emblem;
import mage.util.CardUtil;

class TibaltCosmicImpostorPlayFromExileEffect
extends AsThoughEffectImpl {
    TibaltCosmicImpostorPlayFromExileEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "You may play cards exiled with Tibalt, Cosmic Impostor, and you may spend mana as though it were mana of any color to cast those spells";
    }

    TibaltCosmicImpostorPlayFromExileEffect(TibaltCosmicImpostorPlayFromExileEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return true;
    }

    @Override
    public TibaltCosmicImpostorPlayFromExileEffect copy() {
        return new TibaltCosmicImpostorPlayFromExileEffect(this);
    }

    @Override
    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Emblem tibaltEmblem = (Emblem)game.getEmblem(source.getSourceId());
        if (tibaltEmblem == null) {
            return false;
        }
        UUID sourceId = tibaltEmblem.getSourceId();
        UUID exileId = CardUtil.getExileZoneId(sourceId != null ? sourceId.toString() : source.getSourceId().toString(), game);
        ExileZone exileZone = game.getState().getExile().getExileZone(exileId);
        if (exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        Card cardInExile = game.getCard(objectId);
        if (cardInExile == null) {
            return false;
        }
        UUID mainCardId = cardInExile.getMainCard().getId();
        if (exileZone.contains(mainCardId) && affectedControllerId.equals(source.getControllerId()) && game.getState().getZone(mainCardId).equals((Object)Zone.EXILED)) {
            CardUtil.makeCardPlayable(game, source, cardInExile, false, Duration.Custom, true);
            return true;
        }
        return false;
    }
}

