/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Planes;
import mage.game.Game;
import mage.game.command.Plane;
import mage.game.permanent.Permanent;

class AgyremRestrictionEffect
extends RestrictionEffect {
    AgyremRestrictionEffect() {
        super(Duration.Custom, Outcome.Benefit);
        this.staticText = "Creatures can't attack you";
    }

    AgyremRestrictionEffect(AgyremRestrictionEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.isCreature(game);
    }

    @Override
    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        if (defenderId == null) {
            return true;
        }
        Plane cPlane = game.getState().getCurrentPlane();
        if (cPlane != null && cPlane.getPlaneType().equals((Object)Planes.PLANE_AGYREM)) {
            return !defenderId.equals(source.getControllerId());
        }
        return true;
    }

    @Override
    public AgyremRestrictionEffect copy() {
        return new AgyremRestrictionEffect(this);
    }
}

