/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.Planes;
import mage.game.Game;
import mage.game.command.Plane;
import mage.game.permanent.Permanent;

class AstralArenaBlockRestrictionEffect
extends RestrictionEffect {
    AstralArenaBlockRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "No more than one creature can block each combat";
    }

    AstralArenaBlockRestrictionEffect(AstralArenaBlockRestrictionEffect effect) {
        super(effect);
    }

    @Override
    public AstralArenaBlockRestrictionEffect copy() {
        return new AstralArenaBlockRestrictionEffect(this);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        Plane cPlane = game.getState().getCurrentPlane();
        if (cPlane == null) {
            return false;
        }
        return cPlane.getPlaneType().equals((Object)Planes.PLANE_ASTRAL_ARENA);
    }

    @Override
    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return game.getCombat().getBlockers().isEmpty();
    }
}

