/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Planes;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.command.Plane;
import mage.util.CardUtil;

class TurriIslandEffect
extends CostModificationEffectImpl {
    private static final FilterCard filter = new FilterCard("creature spells");
    private static final String rule = "Creature spells cost {2} less to cast";
    private int amount = 2;

    public TurriIslandEffect(int amount) {
        super(Duration.Custom, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.amount = 2;
        this.staticText = rule;
    }

    protected TurriIslandEffect(TurriIslandEffect effect) {
        super(effect);
        this.amount = effect.amount;
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
    }

    @Override
    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost(abilityToModify, this.amount);
        return true;
    }

    protected boolean selectedByRuntimeData(Card card, Ability source, Game game) {
        return true;
    }

    @Override
    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (abilityToModify instanceof SpellAbility) {
            Plane cPlane = game.getState().getCurrentPlane();
            if (cPlane == null) {
                return false;
            }
            if (!cPlane.getPlaneType().equals((Object)Planes.PLANE_TURRI_ISLAND)) {
                return false;
            }
            Card spellCard = ((SpellAbility)abilityToModify).getCharacteristics(game);
            if (spellCard != null) {
                return filter.match(spellCard, game) && this.selectedByRuntimeData(spellCard, source, game);
            }
        }
        return false;
    }

    @Override
    public TurriIslandEffect copy() {
        return new TurriIslandEffect(this);
    }

    static {
        filter.add(CardType.CREATURE.getPredicate());
    }
}

