/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.common.DrawCardTargetEffect;
import mage.constants.Planes;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.command.Plane;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

class UndercityReachesTriggeredAbility
extends TriggeredAbilityImpl {
    public UndercityReachesTriggeredAbility() {
        super(Zone.COMMAND, null, false);
    }

    protected UndercityReachesTriggeredAbility(UndercityReachesTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public UndercityReachesTriggeredAbility copy() {
        return new UndercityReachesTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent creature;
        Plane cPlane = game.getState().getCurrentPlane();
        if (cPlane == null) {
            return false;
        }
        if (!cPlane.getPlaneType().equals((Object)Planes.PLANE_UNDERCITY_REACHES)) {
            return false;
        }
        if (((DamagedPlayerEvent)event).isCombatDamage() && (creature = game.getPermanent(event.getSourceId())) != null) {
            DrawCardTargetEffect effect = new DrawCardTargetEffect(StaticValue.get(1), true, false);
            effect.setTargetPointer(new FixedTarget(creature.getControllerId()));
            effect.apply(game, this);
            return true;
        }
        return false;
    }

    @Override
    public String getRule() {
        return "Whenever a creature deals combat damage to a player, its controller may a draw a card";
    }
}

