/*
 * Decompiled with CFR 0.152.
 */
package mage.game.draft;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import mage.cards.Card;
import mage.cards.ExpansionSet;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.util.RandomUtil;
import org.apache.log4j.Logger;

public abstract class DraftCube {
    SimpleDateFormat UPDATE_DATE_FORMAT = new SimpleDateFormat("yyyy MMMM", Locale.ENGLISH);
    private static final Logger logger = Logger.getLogger(DraftCube.class);
    private final String name;
    private final String code;
    private String updateInfo;
    private final Date updateDate;
    private static final int boosterSize = 15;
    protected List<CardIdentity> cubeCards = new ArrayList<CardIdentity>();
    protected List<CardIdentity> leftCubeCards = new ArrayList<CardIdentity>();

    protected DraftCube(String name) {
        this(name, "", 0, 0, 0);
    }

    public DraftCube(String name, String updateInfo, int updateYear, int updateMonth, int updateDay) {
        this.name = name;
        this.code = this.getClass().getSimpleName();
        this.updateInfo = updateInfo;
        this.updateDate = updateYear == 0 ? null : ExpansionSet.buildDate(updateYear, updateMonth, updateDay);
    }

    public String getName() {
        String res = this.name;
        ArrayList<String> extra = new ArrayList<String>();
        if (this.updateInfo != null && !this.updateInfo.isEmpty()) {
            extra.add(this.updateInfo);
        }
        if (this.updateDate != null) {
            extra.add(this.UPDATE_DATE_FORMAT.format(this.updateDate));
        }
        if (!extra.isEmpty()) {
            res = res + String.format(" (%s)", String.join((CharSequence)", ", extra));
        }
        return res;
    }

    public void validateData() {
        if (this.cubeCards.isEmpty()) {
            throw new IllegalArgumentException("Can't create cube draft - found empty cards list: " + this.getName());
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getUpdateInfo() {
        return this.updateInfo;
    }

    public void setUpdateInfo(String info) {
        this.updateInfo = info;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public List<CardIdentity> getCubeCards() {
        return this.cubeCards;
    }

    public List<Card> createBooster() {
        ArrayList<Card> booster = new ArrayList<Card>();
        if (this.leftCubeCards.isEmpty()) {
            this.leftCubeCards.addAll(this.cubeCards);
        }
        for (int i = 0; i < 15; ++i) {
            boolean done = false;
            int notValid = 0;
            while (!done) {
                int index = RandomUtil.nextInt(this.leftCubeCards.size());
                CardIdentity cardId = this.leftCubeCards.get(index);
                this.leftCubeCards.remove(index);
                if (!cardId.getName().isEmpty()) {
                    CardInfo cardInfo = null;
                    cardInfo = !cardId.getExtension().isEmpty() ? CardRepository.instance.findCardWithPreferredSetAndNumber(cardId.getName(), cardId.getExtension(), cardId.getCardNumber()) : CardRepository.instance.findPreferredCoreExpansionCard(cardId.getName());
                    if (cardInfo != null) {
                        booster.add(cardInfo.createCard());
                        done = true;
                    } else {
                        logger.warn((Object)new StringBuilder(this.getName()).append(" - Card not found: ").append(cardId.getName()).append(':').append(cardId.extension));
                        ++notValid;
                    }
                } else {
                    logger.error((Object)new StringBuilder(this.getName()).append(" - Empty card name: ").append(cardId.getName()).append(':').append(cardId.extension));
                    ++notValid;
                }
                if (this.leftCubeCards.isEmpty()) {
                    this.leftCubeCards.addAll(this.cubeCards);
                }
                if (notValid <= this.cubeCards.size()) continue;
                logger.error((Object)new StringBuilder(this.getName()).append(" - Booster could not be created, no valid cards found "));
                done = true;
            }
        }
        return booster;
    }

    void removeFromLeftCards(CardIdentity cardId) {
        if (cardId == null) {
            return;
        }
        for (int i = this.leftCubeCards.size() - 1; i >= 0; --i) {
            if (!Objects.equals(this.leftCubeCards.get(i), cardId)) continue;
            this.leftCubeCards.remove(i);
            return;
        }
    }

    public static class CardIdentity {
        private final String name;
        private final String extension;
        private final String number;

        public CardIdentity(String name, String extension) {
            this(name, extension, null);
        }

        public CardIdentity(String name, String extension, String number) {
            this.name = name;
            this.extension = extension;
            this.number = number;
        }

        public String getName() {
            return this.name;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getCardNumber() {
            return this.number;
        }
    }
}

