/*
 * Decompiled with CFR 0.152.
 */
package mage.game.events;

import java.util.UUID;
import mage.abilities.Ability;
import mage.game.events.CoinFlippedEvent;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

public class FlipCoinEvent
extends GameEvent {
    private boolean result;
    private final boolean chosen;
    private final boolean winnable;
    private boolean autoWin = false;
    private int flipCount = 1;

    public FlipCoinEvent(UUID playerId, Ability source, boolean result, boolean chosen, boolean winnable) {
        super(GameEvent.EventType.FLIP_COIN, playerId, source, playerId);
        this.result = result;
        this.chosen = chosen;
        this.winnable = winnable;
    }

    public boolean getResult() {
        return this.result;
    }

    public String getResultName() {
        return CardUtil.booleanToFlipName(this.result);
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public boolean getChosen() {
        return this.chosen;
    }

    public String getChosenName() {
        return CardUtil.booleanToFlipName(this.chosen);
    }

    public boolean isWinnable() {
        return this.winnable;
    }

    public int getFlipCount() {
        return this.flipCount;
    }

    public void setFlipCount(int flipCount) {
        this.flipCount = flipCount;
    }

    public void setAutoWin(boolean autoWin) {
        this.autoWin = autoWin;
    }

    public boolean isAutoWin() {
        return this.autoWin;
    }

    public CoinFlippedEvent createFlippedEvent() {
        return new CoinFlippedEvent(this.playerId, this.sourceId, this.flipCount, this.result, this.chosen, this.winnable);
    }
}

