/*
 * Decompiled with CFR 0.152.
 */
package mage.game.events;

import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.RollDieType;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

public class RollDieEvent
extends GameEvent {
    private final RollDieType rollDieType;
    private final int sides;
    private int resultModifier = 0;
    private int rollsAmount = 1;
    private int bigIdeaRollsAmount = 0;

    public RollDieEvent(Ability source, UUID targetId, RollDieType rollDieType, int sides) {
        super(GameEvent.EventType.ROLL_DIE, targetId, source, source.getControllerId());
        this.rollDieType = rollDieType;
        this.sides = sides;
    }

    public int getResultModifier() {
        return this.resultModifier;
    }

    public void incResultModifier(int modifier) {
        this.resultModifier = CardUtil.overflowInc(this.resultModifier, modifier);
    }

    public RollDieType getRollDieType() {
        return this.rollDieType;
    }

    public int getSides() {
        return this.sides;
    }

    public int getRollsAmount() {
        return this.rollsAmount;
    }

    public void doubleRollsAmount() {
        this.rollsAmount = CardUtil.overflowMultiply(this.rollsAmount, 2);
    }

    public int getBigIdeaRollsAmount() {
        return this.bigIdeaRollsAmount;
    }

    public void incBigIdeaRollsAmount() {
        this.bigIdeaRollsAmount = CardUtil.overflowInc(this.bigIdeaRollsAmount, 1);
    }
}

