/*
 * Decompiled with CFR 0.152.
 */
package mage.game.events;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.Zone;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class ZoneChangeEvent
extends GameEvent {
    private Zone fromZone;
    private Zone toZone;
    private Zone originalToZone;
    private Permanent target;
    private Ability source;

    public ZoneChangeEvent(Permanent target, Ability source, UUID playerId, Zone fromZone, Zone toZone) {
        super(GameEvent.EventType.ZONE_CHANGE, target.getId(), source, playerId);
        this.fromZone = fromZone;
        this.setToZone(toZone);
        this.target = target;
        this.source = source;
    }

    public ZoneChangeEvent(Permanent target, Ability source, UUID playerId, Zone fromZone, Zone toZone, List<UUID> appliedEffects) {
        super(GameEvent.EventType.ZONE_CHANGE, target.getId(), source, playerId);
        this.fromZone = fromZone;
        this.setToZone(toZone);
        this.target = target;
        this.source = source;
        if (appliedEffects != null) {
            this.appliedEffects = appliedEffects;
        }
    }

    public ZoneChangeEvent(UUID targetId, Ability source, UUID playerId, Zone fromZone, Zone toZone) {
        super(GameEvent.EventType.ZONE_CHANGE, targetId, source, playerId);
        this.fromZone = fromZone;
        this.setToZone(toZone);
        this.source = source;
    }

    public ZoneChangeEvent(UUID targetId, Ability source, UUID playerId, Zone fromZone, Zone toZone, List<UUID> appliedEffects) {
        super(GameEvent.EventType.ZONE_CHANGE, targetId, source, playerId);
        this.fromZone = fromZone;
        this.setToZone(toZone);
        this.source = source;
        if (appliedEffects != null) {
            this.appliedEffects = appliedEffects;
        }
    }

    public ZoneChangeEvent(Permanent target, UUID playerId, Zone fromZone, Zone toZone) {
        this(target, null, playerId, fromZone, toZone);
    }

    public ZoneChangeEvent(UUID targetId, UUID playerId, Zone fromZone, Zone toZone) {
        this(targetId, null, playerId, fromZone, toZone);
    }

    public Zone getFromZone() {
        return this.fromZone;
    }

    public Zone getToZone() {
        return this.toZone;
    }

    public void setToZone(Zone toZone) {
        this.toZone = toZone;
        if (this.originalToZone == null && toZone != null) {
            this.originalToZone = toZone;
        }
    }

    public Permanent getTarget() {
        return this.target;
    }

    public void setTarget(Permanent target) {
        this.target = target;
    }

    public boolean isDiesEvent() {
        return this.toZone == Zone.GRAVEYARD && this.fromZone == Zone.BATTLEFIELD;
    }

    public Zone getOriginalToZone() {
        return this.originalToZone;
    }

    public Ability getSource() {
        return this.source;
    }

    @Override
    public String toString() {
        return super.toString() + ", from " + (Object)((Object)this.getFromZone()) + " to " + (Object)((Object)this.getToZone()) + ", " + (this.target == null ? "no target" : "target " + this.target) + ", " + (this.source == null ? "no source" : "source " + this.source);
    }
}

